package cwp;

import java.sql.*;

/** Tworzy prost tabel "pracownicy" uywajc w tym celu klasy DatabaseUtilities.
 */

public class TworzeniePracownikow {
  public static Connection stworzPracownikow(String sterownik,
                                             String url,
                                             String nazwaUzytkownika,
                                             String haslo,
                                             boolean zamknij) {
    String format =
      "(id int, imie varchar(32), nazwisko varchar(32), " +
      "jezyk varchar(16), wynagrodzenie float)";
    String[] pracownicy =
      {"(1, 'Jan', 'Kowalski', 'COBOL', 42500)",
       "(2, 'Piotr', 'Nowak',   'C++',   62000)",
       "(3, 'Zbigniew',  'Jeziorak', 'brak',  15500)",
       "(4, 'Tomasz', 'Baranski', 'Smalltalk', 51500)",
       "(5, 'Anna', 'Frank', 'Common Lisp', 51500)",
       "(6, 'Przemyslaw', 'Sopocki', 'Java', 98000)",
       "(7, 'Justyna', 'Kalita', 'Java', 114750)",
       "(8, 'Rafal', 'Kowal', 'Java', 128500)" };
    return(NarzedziaBazyDanych.stworzTabele(sterownik, url,
                                            nazwaUzytkownika, haslo,
                                            "pracownicy",
                                            format, pracownicy,
                                            zamknij));    
  }

  public static void main(String[] args) {
    if (args.length < 5) {
      informacja();
      return;
    }
    String nazwaDostawcy = args[4];
    int dostawca = NarzedziaSterownika.dajProducent(nazwaDostawcy);
    if (dostawca == NarzedziaSterownika.NIEZNANY) {
      informacja();
      return;
    }
    String sterownik = NarzedziaSterownika.dajSterownik(dostawca);
    String serwer = args[0];
    String nazwaBazy = args[1];
    String url =
      NarzedziaSterownika.stworzURL(serwer, nazwaBazy, dostawca);
    String nazwaUzytkownika = args[2];
    String haslo = args[3];
    stworzPracownikow(sterownik, url, nazwaUzytkownika, haslo, true);
  }

  private static void informacja() {
    System.out.println("Sposob uzycia: EmployeeCreation serwer nazwaBazy " +
                       "nazwaUzytkownika haslo oracle|sybase.");
  }
}
