package cwp;

import java.sql.*;

/** Tworzy prost tabel o nazwie "owoce" w bazie danych
 *  Oracle lub Sybase.
 *  <P>
 */

public class TworzenieOwocow {
  public static void main(String[] args) {
    if (args.length < 5) {
       informacja();
      return;
    }
    String nazwaDostawcy = args[4];
    int dostawca = NarzedziaSterownika.dajProducent(nazwaDostawcy);
    if (dostawca == NarzedziaSterownika.NIEZNANY) {
       informacja();
      return;
    }
    String sterownik = NarzedziaSterownika.dajSterownik(dostawca);
    String serwer = args[0];
    String nazwaBazy = args[1];
    String url =
      NarzedziaSterownika.stworzURL(serwer, nazwaBazy, dostawca);
    String nazwaUzytkownika = args[2];
    String haslo = args[3];
    String format =
      "(kwartal int, " +
      "jablka int, sprzedazjablek float, " +
      "pomarancze int, sprzedazpomaranczy float, " +
      "najlepszysprzedawca varchar(16))";
    String[] wiersze =
    { "(1, 32248, 3547.28, 18459, 3138.03, 'Maria')",
      "(2, 35009, 3850.99, 18722, 3182.74, 'Jan')",
      "(3, 39393, 4333.23, 18999, 3229.83, 'Piotr')",
      "(4, 42001, 4620.11, 19333, 3286.61, 'Maria')" };
    Connection polaczenie = 
      NarzedziaBazyDanych.stworzTabele(sterownik, url,
                                       nazwaUzytkownika, haslo,
                                       "owoce", format, wiersze,
                                       false);
    // Test sprawdzajcy poprawne utworzenie tabeli. W celu
    // zwikszenia wydajnoci uywa starego poczenia.
    NarzedziaBazyDanych.pokazTabele(polaczenie, "owoce",
                                    11, true);
  }

  private static void informacja() {
     System.out.println("Sposob uzycia: java TworzenieOwocow serwer nazwaBazy " +
                        "nazwaUzytkownika haslo oracle|sybase.");
  }
}
