package cwp;

import java.sql.*;

/** Tworzy poczenie z baz Oracle lub Sybase i wywietla tabel "pracownicy".
 *  <P>
 */

public class TestPracownikow {
  public static void main(String[] args) {
    if (args.length < 5) {
      informacja();
      return;
    }
    String nazwaDostawcy = args[4];
    int dostawca = NarzedziaSterownika.dajProducent(nazwaDostawcy);
    if (dostawca == NarzedziaSterownika.NIEZNANY) {
      informacja();
      return;
    }
    String sterownik = NarzedziaSterownika.dajSterownik(dostawca);
    String serwer = args[0];
    String nazwaBazy = args[1];
    String url =
      NarzedziaSterownika.stworzURL(serwer, nazwaBazy, dostawca);
    String nazwaUzytkownika = args[2];
    String haslo = args[3];
    NarzedziaBazyDanych.pokazTabele(sterownik, url,
                                    nazwaUzytkownika, haslo,
                                    "pracownicy", 12, true);
  }

  private static void informacja() {
    System.out.println("Sposob uzycia: EmployeeTest serwer nazwaBazy " +
                       "nazwaUzytkownika haslo oracle|sybase.");
  }
}
