package cwp;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

/** Interaktywna przegladarka zapyta. Tworzy poczenie z 
 *  okrelon baz danych Oracle lub Sybase, wykonuje zapytanie
 *  i wywietla wyniki w obiekcie klasy JTable.
 *  <P>
 */

public class PrzegladarkaZapytan extends JFrame
                         implements ActionListener{
  public static void main(String[] args) {
    new PrzegladarkaZapytan();
  }

  private JTextField poleSerwera, poleNazwyBazy,
                     poleZapytania, poleUzytkownika;
  private JRadioButton przyciskOracle, przyciskSybase;
  private JPasswordField poleHasla;
  private JButton przyciskPokazWyniki;
  Container panelZawartosci;
  private JPanel panelTabeli;
  
  public PrzegladarkaZapytan() {
    super("Przegladarka zapytan do bazy danych");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    panelZawartosci = getContentPane();
    panelZawartosci.add(makeControlPanel(), BorderLayout.NORTH);
    pack();
    setVisible(true);
  }

  /** Po naciniciu przycisku "Pokaz wyniki zapytania" lub 
   *  przycisku RETURN, w momencie gdy kursor znajduje sie w polu tekstowym
   *   baza danych jest przeszukiwana,
   *  a wyniki umieszczane w obiekcie klasy JTable, za okno
   *  rozszerzane w celu pomieszczenia caej tabeli.
   */
  
  public void actionPerformed(ActionEvent event) {
    String serwer = poleSerwera.getText();
    String nazwaBazy = poleNazwyBazy.getText();
    String nazwaUzytkownika = poleUzytkownika.getText();
    String haslo =
      String.valueOf(poleHasla.getPassword());
    String zapytanie = poleZapytania.getText();
    int dostawca;
    if (przyciskOracle.isSelected()) {
      dostawca = NarzedziaSterownika.ORACLE;
    } else {
      dostawca = NarzedziaSterownika.SYBASE;
    }
    if (panelTabeli != null) {
      panelZawartosci.remove(panelTabeli);
    }
    panelTabeli = makeTablePanel(serwer, nazwaBazy, dostawca,
                                nazwaUzytkownika, haslo,
                                zapytanie);
    panelZawartosci.add(panelTabeli, BorderLayout.CENTER);
    pack();
  }

  // Wykonuje zapytanie i umieszcza wynik w obiekcie klasy
  // JTable umieszczonej wewntrz JPanel.
  
  private JPanel makeTablePanel(String serwer,
                                String nazwaBazy,
                                int dostawca,
                                String nazwaUzytkownika,
                                String haslo,
                                String zapytanie) {
    String sterownik = NarzedziaSterownika.dajSterownik(dostawca);
    String url = NarzedziaSterownika.stworzURL(serwer, nazwaBazy, dostawca);
    BDRezultat wyniki =
      NarzedziaBazyDanych.dajRezultat(sterownik, url,
                                        nazwaUzytkownika, haslo,
                                        zapytanie, true);
    JPanel panel = new JPanel(new BorderLayout());
    if (wyniki == null) {
      panel.add(makeErrorLabel());
      return(panel);
    }
    ModelTabeliDBRezultat model =
      new ModelTabeliDBRezultat(wyniki);
    JTable tabela = new JTable(model);
    tabela.setFont(new Font("Serif", Font.PLAIN, 17));
    tabela.setRowHeight(28);
    JTableHeader naglowek = tabela.getTableHeader();
    naglowek.setFont(new Font("SansSerif", Font.BOLD, 13));
    panel.add(tabela, BorderLayout.CENTER);
    panel.add(naglowek, BorderLayout.NORTH);
    panel.setBorder
      (BorderFactory.createTitledBorder("Wyniki zapytania"));
    return(panel);
  }

  // Panel zawierajcy pola tekstowe, pola wyboru
  // oraz przyciski.
  
  private JPanel makeControlPanel() {
    JPanel panel = new JPanel(new GridLayout(0, 1));
    panel.add(makeHostPanel());
    panel.add(makeUsernamePanel());
    panel.add(makeQueryPanel());
    panel.add(makeButtonPanel());
    panel.setBorder
      (BorderFactory.createTitledBorder("Dane zapytania"));
    return(panel);
  }

  // Panel majcy pola edycyjne suce do wprowadzenia nazwy
  // serwera oraz bazy danych, jak rwnie pola wyboru sterownika
  // Umieszczane s one w panelu sterowania.
  
  private JPanel makeHostPanel() {
    JPanel panel = new JPanel();
    panel.add(new JLabel("Serwer:"));
    poleSerwera = new JTextField(15);
    panel.add(poleSerwera);
    panel.add(new JLabel("    Nazwa bazy:"));
    poleNazwyBazy = new JTextField(15);
    panel.add(poleNazwyBazy);
    panel.add(new JLabel("    Sterownik:"));
    ButtonGroup grupaDostawcow = new ButtonGroup();
    przyciskOracle = new JRadioButton("Oracle", true);
    grupaDostawcow.add(przyciskOracle);
    panel.add(przyciskOracle);
    przyciskSybase = new JRadioButton("Sybase");
    grupaDostawcow.add(przyciskSybase);
    panel.add(przyciskSybase);
    return(panel);
  }

  // Panel majcy pola edycyjne suce do wprowadzenia nazwy uytkownika oraz hasa.
  // Umieszczany w panelu sterowania.
  
  private JPanel makeUsernamePanel() {
    JPanel panel = new JPanel();
    poleUzytkownika = new JTextField(10);
    poleHasla = new JPasswordField(10);
    panel.add(new JLabel("Nazwa uzytkownika: "));
    panel.add(poleUzytkownika);
    panel.add(new JLabel("    Haslo:"));
    panel.add(poleHasla);
    return(panel);
  }

  // Panel zawierajcy pole edycyjne suce do wprowadzenia zapyta.
  // Umieszczany w panelu sterowania.
  
  private JPanel makeQueryPanel() {
    JPanel panel = new JPanel();
    poleZapytania = new JTextField(40);
    poleZapytania.addActionListener(this);
    panel.add(new JLabel("Zapytanie:"));
    panel.add(poleZapytania);
    return(panel);
  }

  // Panel zawierajcy pole edycyjne z przyciskiem "Pokaz wyniki".
  // Umieszczany w panelu sterowania.
  
  private JPanel makeButtonPanel() {
    JPanel panel = new JPanel();
    przyciskPokazWyniki = new JButton("Pokaz wyniki");
    przyciskPokazWyniki.addActionListener(this);
    panel.add(przyciskPokazWyniki);
    return(panel);
  }

  // Pokazuje komunikat o bdzie w przypadku wysania zego zapytania.
  
  private JLabel makeErrorLabel() {
    JLabel label = new JLabel("Brak wynikow", JLabel.CENTER);
    label.setFont(new Font("Serif", Font.BOLD, 36));
    return(label);
  }
}
