package cwp;

import java.sql.*;

/** Przykad sprawdzajcy rnice w czasie wykonywania
 *  powtarzanych zwykych zapyta oraz zapyta
 *  prekompilowanych. Wyniki te mog rni si znacznie
 *  pomidzy bazami danych a sterownikami. W przypadku uywanej przeze mnie konfiguracji
 *  oraz sterownikw, wykonanie prekompilowanych zapyta w bazie Oracle zajo
 *  jedynie poow czasu potrzebnego do wykonania zwykych zapyta podczas uywania 
 *  poczenia modemowego oraz 70% czasu podczas uywania szybkiego poczenia LAN.
 *  Podczas stosowania bazy Sybase, czasy wykonywania w obu przypadkach byy identyczne.
 *  <P>
 */

public class PrekompilowaneZapytania {
  public static void main(String[] args) {
    if (args.length < 5) {
      informacja();
      return;
    }
    String nazwaDostawcy = args[4];
    int dostawca = NarzedziaSterownika.dajProducent(nazwaDostawcy);
    if (dostawca == NarzedziaSterownika.NIEZNANY) {
      informacja();
      return;
    }
    String sterownik = NarzedziaSterownika.dajSterownik(dostawca);
    String serwer = args[0];
    String nazwaBazy = args[1];
    String url =
      NarzedziaSterownika.stworzURL(serwer, nazwaBazy, dostawca);
    String nazwaUzytkownika = args[2];
    String haslo = args[3];
    // Naley zastosowa argument "print" jedynie w celu potwierdzenia, e wszystko,
    // dziaa prawidowo, a nie podczas pobierania wynikw testu.
    boolean drukuj = false;
    if ((args.length > 5) && (args[5].equals("print"))) {
      drukuj = true;
    }
    Connection polaczenie =
      getConnection(sterownik, url, nazwaUzytkownika, haslo);
    if (polaczenie != null) {
      doPreparedStatements(polaczenie, drukuj);
      doRawQueries(polaczenie, drukuj);
    }
  }

  private static void doPreparedStatements(Connection polacz,
                                           boolean drukuj) {
    try {
      String formatZapytania =
        "SELECT nazwisko FROM pracownicy WHERE wynagrodzenie > ?";
      PreparedStatement instrukcja =
        polacz.prepareStatement(formatZapytania);
      long czasRozpoczecia = System.currentTimeMillis();
      for(int i=0; i<40; i++) {
        instrukcja.setFloat(1, i*5000);
        ResultSet wyniki = instrukcja.executeQuery();
        if (drukuj) {
          showResults(wyniki);
        }
      }
      long czasZakonczenia = System.currentTimeMillis();
      double czasDzialania = (czasZakonczenia - czasRozpoczecia)/1000.0;
      System.out.println("40 krotne wykonania instrukcji prekompilowanej " +
                         "zajelo " +
                         czasDzialania + " sekund.");
    } catch(SQLException sqle) {
      System.out.println("Blad wykonywania instrukcji: " + sqle);
    }
  }

  public static void doRawQueries(Connection polacz,
                                  boolean drukuj) {
    try {
      String formatZapytania =
        "SELECT nazwisko FROM pracownicy WHERE wynagrodzenie > ";
      Statement instrukcja = polacz.createStatement();
      long czasRozpoczecia = System.currentTimeMillis();
      for(int i=0; i<40; i++) {
        ResultSet wyniki =
          instrukcja.executeQuery(formatZapytania + (i*5000));
        if (drukuj) {
          showResults(wyniki);
        }
      }
      long czasZakonczenia = System.currentTimeMillis();
      double czasDzialania = (czasZakonczenia - czasRozpoczecia)/1000.0;
      System.out.println("40 krotne wykonanie zwyklej instrukcji " +
                         "zajelo " +
                         czasDzialania + " sekund.");
    } catch(SQLException sqle) {
      System.out.println("Blad wykonywania instrukcji: " + sqle);
    }
  } 

  private static void showResults(ResultSet wyniki)
      throws SQLException {
    while(wyniki.next()) {
      System.out.print(wyniki.getString(1) + " ");
    }
    System.out.println();
  }
    
  private static Connection getConnection(String sterownik,
                                          String url,
                                          String nazwaUzytkownika,
                                          String haslo) {
    try {
      Class.forName(sterownik);
      Connection polaczenie =
        DriverManager.getConnection(url, nazwaUzytkownika, haslo);
      return(polaczenie);
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Blad podczas wczytywania sterownika: " + cnfe);
      return(null);
    } catch(SQLException sqle) {
      System.err.println("Blad polaczenia: " + sqle);
      return(null);
    }
  }

  private static void informacja() {
    System.out.println("Sposob uzycia: PreparedStatements serwer " +
                       "nazwaBazy nazwaUzytkownika haslo " +
                       "oracle|sybase [print].");
  }
}
