package cwp;

import java.sql.*;

/** Przykad poczenia JDBC korzystajcego z bazy Oracle lub
 *  Sybase oraz wywietlenie wartoci kolumn
 *  tabeli o nazwie "owoce".
 *  <P>
 */

public class OwocowyTest {

  /** Pobiera z wiersza polece nazw serwera, bazy danych, uytkownika, haso
   *  oraz nazw producenta. Nazwa producenta uywana
   *  jest w celu okrelenia sterownika, ktry ma zosta
   *  wczytany oraz formatu adresu URL uywanego do poczenia. Nazwa
   *  sterownika, adres URL, nazwa uytkownika, serwer oraz haso s nastpnie
   *  przekazywane do metody showFruitTable.
   */
  
  public static void main(String[] args) {
    if (args.length < 5) {
      informacja();
      return;
    }
    String nazwaDostawcy = args[4];
    int dostawca = NarzedziaSterownika.dajProducent(nazwaDostawcy);
    if (dostawca == NarzedziaSterownika.NIEZNANY) {
      informacja();
      return;
    }
    String sterownik = NarzedziaSterownika.dajSterownik(dostawca);
    String serwer = args[0];
    String nazwaBazy = args[1];
    String url = NarzedziaSterownika.stworzURL(serwer, nazwaBazy, dostawca);
    String nazwaUzytkownika = args[2];
    String haslo = args[3];
    pokazTabeleOwocow(sterownik, url, nazwaUzytkownika, haslo);
  }

  /** Pobierz tabel i wywietl wszystkie zawarte w niej wartoci. */
  
  public static void pokazTabeleOwocow(String sterownik,
                                    String url,
                                    String nazwaUzytkownika,
                                    String haslo) {
    try {
      // Naley wczyta sterownik do bazy danych, jeli nie zostao to zrobione wczesniej
      Class.forName(sterownik);
      // Ustanowienie poczenia sieciowego z baz danych
      Connection polaczenie =
        DriverManager.getConnection(url, nazwaUzytkownika, haslo);
      // Naley pobiera informacje o caej bazie danych.
      DatabaseMetaData dbMetaData = polaczenie.getMetaData();
      String nazwaProduktu =
        dbMetaData.getDatabaseProductName();
      System.out.println("Baza danych: " + nazwaProduktu);
      String wersjaBazy =
        dbMetaData.getDatabaseProductVersion();
      System.out.println("Wersja: " + wersjaBazy + "\n");
      System.out.println("Porownanie jablek i pomaranczy\n" +
                         "============================");
      Statement instrukcja = polaczenie.createStatement();
      String zapytanie = "SELECT * FROM owoce";
      // Wysya zapytanie do bazy danych i zachowuje wyniki
      ResultSet zestawWynikow = instrukcja.executeQuery(zapytanie);
      // Pobiera informacje o konkretnej tabeli
      ResultSetMetaData metadaneWynikow =
        zestawWynikow.getMetaData();
      int liczbaKolumn = metadaneWynikow.getColumnCount();
      // Indeks kolumn rozpoczyna sie od 1 (SQL), a nie 0 (Java).
      for(int i=1; i<liczbaKolumn+1; i++) {
        System.out.print(metadaneWynikow.getColumnName(i) +
                         "  ");
      }
      System.out.println();
      // Wyswietla wyniki
      while(zestawWynikow.next()) {
        // Kwarta
        System.out.print("    " + zestawWynikow.getInt(1));
        // Ilo jabek
        System.out.print("     " + zestawWynikow.getInt(2));
        // Sprzeda jabek
        System.out.print("   " + zestawWynikow.getFloat(3) + "PLN");
        // Ilo pomaraczy
        System.out.print("    " + zestawWynikow.getInt(4));
        // Sprzeda pomaraczy
        System.out.print("    " + zestawWynikow.getFloat(5) + "PLN");
        // Najlepsi sprzedawcy
        System.out.println("      " + zestawWynikow.getString(6));
      }
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Bd podczas wczytywania sterownika: " + cnfe);
    } catch(SQLException sqle) {
      System.err.println("Bd poczenia: " + sqle);
    }
  }

  private static void informacja() {
    System.out.println("Sposb uycia: java OwocowyTest serwer nazwaBazy " +
                       "nazwaUzytkownika haso oracle|sybase.");
  }
}
