package cwp;

/** Kilka prostych narzdzi umoliwiajcych utworzenie adresw 
 *  sucych do pocze JDBC z bazami Oracle oraz Sybase. 
 *  Ten kod <I>nie</I> jest kodem oglnego przeznaczenia.
 *  Jest on jedynie specyficzny dla mojego lokalnego komputera.
 */

public class NarzedziaSterownika {
  public static final int ORACLE = 1;
  public static final int SYBASE = 2;
  public static final int NIEZNANY = -1;

  /** Tworzy adres URL w formacie wymaganym przez 
   *  uywane sterowniki Oracle oraz Sybase.
   */
  
  public static String stworzURL(String serwer, String nazwaBazy,
                               int dostawca) {
    if (dostawca == ORACLE) {
      return("jdbc:oracle:thin:@" + serwer + ":1521:" + nazwaBazy);
    } else if (dostawca == SYBASE) {
      return("jdbc:sybase:Tds:" + serwer  + ":1521" +
             "?SERVICENAME=" + nazwaBazy);
    } else {
      return(null);
    }
  }

  /** Naley utworzy pen nazw sterownika. */
  
  public static String dajSterownik(int dostawca) {
    if (dostawca == ORACLE) {
      return("oracle.jdbc.driver.OracleDriver");
    } else if (dostawca == SYBASE) {
      return("com.sybase.jdbc.SybDriver");
    } else {
      return(null);
    }
  }

  /** Naley odwzorowa nazw na warto typu int. */

  public static int dajProducent(String nazwaDostawcy) {
    if (nazwaDostawcy.equalsIgnoreCase("oracle")) {
      return(ORACLE);
    } else if (nazwaDostawcy.equalsIgnoreCase("sybase")) {
      return(SYBASE);
    } else {
      return(NIEZNANY);
    }
  }
}
