package cwp;
import javax.swing.*;
import java.awt.*;   // Z uwagi na klasy Color i Container.

/** Klasy narzdziowe uatwiajce operowanie oknami Swing.  */

public class NarzedziaOkienkowe {

  /** Ustawienie wygldu okna zgodnie ze standardowymi ustawieniami systemu.
   *  Jeeli operacja si nie powiedzie, zostanie zastosowane domylne ustawienie - Metal (Java).
   */

  public static void ustawWygladSystemowy() {
    try {
     UIManager.setLookAndFeel(
       UIManager.getSystemLookAndFeelClassName());
    } catch(Exception e) {
      System.out.println("Bd podczas wprowadzania systemowego schematu wywietlania okien: " + e);
    }
  }

  public static void ustawWygladJava() {
    try {
     UIManager.setLookAndFeel(
       UIManager.getCrossPlatformLookAndFeelClassName());
    } catch(Exception e) {
      System.out.println("Bd podczas wprowadzania schematu wywietlania Java: " + e);
    }
  }

   public static void ustawWygladMotif() {
    try {
      UIManager.setLookAndFeel(
        "com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    } catch(Exception e) {
      System.out.println("Bd podczas wprowadzania schematu wywietlania Motif: " + e);
    }
  }

  /** Uproszczenie wywietlania komponentu JPanel oraz innych obiektw klasy Container.
   *  Wywietlenie obiektu JFrame, ktry zawiera obiekt Container penicy funkcj pola zawartoci.
   */

  public static JFrame otworzWJFrame(Container zawartosc,
                                    int szerokosc,
                                    int wysokosc,
                                    String tytul,
                                    Color kolorTla) {
    JFrame ramka = new JFrame(tytul);
    ramka.setBackground(kolorTla);
    zawartosc.setBackground(kolorTla);
    ramka.setSize(szerokosc, wysokosc);
    ramka.setContentPane(zawartosc);
    ramka.addWindowListener(new NasluchWyjscia());
    ramka.setVisible(true);
    return(ramka);
  }

  /** Ustawienie biaego koloru ta (Color.white). */

  public static JFrame otworzWJFrame(Container zawartosc,
                                    int szerokosc,
                                    int wysokosc,
                                    String tytul) {
    return(otworzWJFrame(zawartosc, szerokosc, wysokosc,
                        tytul, Color.white));
  }

  /** Ustawienie biaego koloru ta oraz tytuu ramki JFrame odpowiadajcego
   *  nazwie klasy Container.
   */

  public static JFrame otworzWJFrame(Container zawartosc,
                                    int szerokosc,
                                    int wysokosc) {
    return(otworzWJFrame(zawartosc, szerokosc, wysokosc,
                        zawartosc.getClass().getName(),
                        Color.white));
  }
}
