package cwp;

import java.sql.*;
import java.util.*;

/** Klasa uywana do przechowywania kompletnych wynikw zwrconych przez zapytanie JDBC.
 *  Rni si od klasy ResultSet pod wieloma wzgledami:
 *  <UL>
 *    <LI>Klasa ResultSet niekoniecznie musi zawiera wszystkie dane;
 *        W przypadku gdy poprosi si o kocowe wiersze
 *        zostanie nawizane ponowne poczenie z baz danych.
 *    <LI>Ta klasa przechowuje wyniki w postaci obiektw klasy String, umieszczone w tablicy.
 *    <LI>Ta klasa przechowuje informacje zawarte w klasach DatabaseMetaData (nazwa bazy danych
 *        oraz wersja) oraz ResultSetMetaData
 *        (nazwy kolumn).
 *    <LI>Ta klasa zawiera metod o nazwie doTabeliHTML zwracajc
 *        wyniki w postaci dugiego acucha znakowego okrelajcego 
 *        tabele HTML.
 *  </UL>
 *  <P>
 */

public class BDRezultat {
  private Connection polaczenie;
  private String nazwaBazy;
  private String wersjaBazy;
  private int liczbaKolumn;
  private String[]nazwyKolumn;
  private Vector wynikZapytania;
  String[]wiersze;

  public BDRezultat(Connection polaczenie,
                    String nazwaBazy,
                    String wersjaBazy,
                    int liczbaKolumn,
                    String[] nazwyKolumn) {
    this.polaczenie = polaczenie;
    this.nazwaBazy = nazwaBazy;
    this.wersjaBazy = wersjaBazy;
    this.liczbaKolumn = liczbaKolumn;
    this.nazwyKolumn = nazwyKolumn;
    wiersze = new String[liczbaKolumn];
    wynikZapytania = new Vector();
  }

  public Connection dajPolaczenie() {
    return(polaczenie);
  }
  
  public String dajNazwaBazy() {
    return(nazwaBazy);
  }

  public String dajWersjaBazy() {
    return(wersjaBazy);
  }

  public int dajLiczbaKolumn() {
    return(liczbaKolumn);
  }

  public String[] dajNazwyKolumn() {
    return(nazwyKolumn);
  }

  public int dajLiczbaWierszy() {
    return(wynikZapytania.size());
  }

  public String[] dajWiersz(int index) {
    return((String[])wynikZapytania.elementAt(index));
  }

  public void dodajWiersz(String[] wiersz) {
    wynikZapytania.addElement(wiersz);
  }

  /** Zwraca wyniki w postaci tabeli HTML, majcej
   *  nagwki zgodne z nazwami kolumn oraz reszt wynikw umieszczon w 
   *  normalnych komrkach tabeli.
   */
  
  public String doTabeliHTML(String kolorNaglowka) {
    StringBuffer bufor =
      new StringBuffer("<TABLE BORDER=1>\n");
    if (kolorNaglowka != null) {
      bufor.append("  <TR BGCOLOR=\"" + kolorNaglowka +
                    "\">\n    ");
    } else {
      bufor.append("  <TR>\n    ");
    }
    for(int kolumna=0; kolumna<dajLiczbaKolumn(); kolumna++) {
      bufor.append("<TH>" + nazwyKolumn[kolumna]);
    }
    for(int wiersz=0; wiersz<dajLiczbaWierszy(); wiersz++) {
      bufor.append("\n  <TR>\n    ");
      String[] rowData = dajWiersz(wiersz);
      for(int kolumna=0; kolumna<dajLiczbaKolumn(); kolumna++) {
        bufor.append("<TD>" + rowData[kolumna]);
      }
    }
    bufor.append("\n</TABLE>");
    return(bufor.toString());
  } 
}
