import java.sql.*;

public class CreateTable {
  public static void main(String[] args) {
    createTable();
  }

  public static void createTable() {
    try {
      Class.forName("oracle.jdbc.driver.OracleDriver");
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Error loading driver: " + cnfe);
      return;
    }
    // Disguise host and port before publishing
    String dbURL =
      "jdbc:oracle:thin:@aplcen.apl.jhu.edu:1521:PTE";
    Connection connection;
    try {
      connection =
        DriverManager.getConnection(dbURL, "hall", "hall");
    } catch(SQLException sqle) {
      System.err.println("Error making connection: " + sqle);
      return;
    }
    // TO DO: Group all try/catch except for table dropping
    Statement statement;
    try {
      statement = connection.createStatement();
      } catch(SQLException sqle) {
      System.err.println("Error creating statement: " + sqle);
      return;
    }
    try {
      statement.execute("DROP TABLE employees");
    } catch(SQLException sqle) { /* No such table */ }
    try {
      // Uppercase for CHAR for consistency?
      String createCommand =
        "CREATE TABLE employees " +
        "(firstname varchar(32), lastname varchar(32), " +
        "id int, salary float)";
      statement.execute(createCommand);
      String insertCommand1 =
        "INSERT INTO employees VALUES('bill', 'gates', 1, 2.3)";
      statement.execute(insertCommand1);
      String insertCommand2 =
        "INSERT INTO employees VALUES('scott', 'mcnealy', 1, 4.5)";
      statement.execute(insertCommand2);
      String insertCommand3 =
        "INSERT INTO employees VALUES('marty', 'hall', 1, 5.6)";
      statement.execute(insertCommand3);
      DatabaseMetaData metaData = connection.getMetaData();
      System.out.println("Database: " +
                         metaData.getDatabaseProductName());
      System.out.println("Version: " +
                         metaData.getDatabaseProductVersion());
      String query =
        "SELECT firstname, lastname, id, salary FROM employees";
      ResultSet queryResults = statement.executeQuery(query);
      System.out.println("\nEMPLOYEES:");
      while(queryResults.next()) {
        System.out.println(queryResults.getString(1) + " " +
                           queryResults.getString(2) + " " +
                           queryResults.getInt(3) + " " +
                           queryResults.getFloat(4));
      }
      connection.close();
    } catch(SQLException sqle) {
      System.err.println("Error: " + sqle);
    }
  }
}
                         

    
