import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/** Aplet odczytujacy parametry o nazwach firstName, lastName, and
 *  emailAddress a nastepnie wysylajacy je do programu umieszczonego 
 *  na wskazanym serwerze, porcie oraz adresie URI przy uzyciu metody POST.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class SendPost extends Applet
                      implements ActionListener {
  private LabeledTextField poleImienia, poleNazwiska,
                           poleAdresuEmail, poleNazwySerwera,
                           poleNumeruPortu, poleAdresuURI;
  private Button przyciskWyslij;
  private TextArea obszarWyniku;
  URL biezacaStrona;
  
  public void init() {
    setBackground(Color.white);
    setLayout(new BorderLayout());
    Panel panelWejsciowy = new Panel();
    panelWejsciowy.setLayout(new GridLayout(9, 1));
    panelWejsciowy.setFont(new Font("Serif", Font.BOLD, 14));
    poleImienia =
      new LabeledTextField("Imie:", 15);
    panelWejsciowy.add(poleImienia);
    poleNazwiska =
      new LabeledTextField("Nazwisko:", 15);
    panelWejsciowy.add(poleNazwiska);
    poleAdresuEmail =
      new LabeledTextField("Adres Email:", 30);
    panelWejsciowy.add(poleAdresuEmail);
    Canvas separator1 = new Canvas();
    panelWejsciowy.add(separator1);
    poleNazwySerwera =
      new LabeledTextField("Serwer:", 15);
    
    // Aplety wczytywane poprzez siec moga komunikowac sie jedynie z serwerem,
    // z ktorego zostaly pobrane.
    poleNazwySerwera.getTextField().setEditable(false);
    
    biezacaStrona = getCodeBase();
    // metoda getHost zwraca pusty lancuch znakowy w przypadku apletow wczytanych z dysku lokalnego.
    String serwer = biezacaStrona.getHost();
    String komunikatWynikowy = "W tym miejscu pokazany zostanie komunikat...";
    if (serwer.length() == 0) {
      komunikatWynikowy = "Blad: Ten aplet musi zostac wczytany \n" +
                       "z rzeczywistego serwera WWW przy uzyciu protokolu HTTP, \n" +
                       "a nie z lokalnego dysku za pomoca okreslenia adresu URL\n" +
                       "postaci 'file:'. Mozliwe jest jednak uruchomienie serwera WWW\n" +
                       "na lokalnym serwerze.";
      setEnabled(false);
    }
    poleNazwySerwera.getTextField().setText(serwer);
    panelWejsciowy.add(poleNazwySerwera);
    poleNumeruPortu =
      new LabeledTextField("Port (-1 oznacza port domyslny):", 4);
    String portString = String.valueOf(biezacaStrona.getPort());
    poleNumeruPortu.getTextField().setText(portString);
    panelWejsciowy.add(poleNumeruPortu);
    poleAdresuURI =
      new LabeledTextField("URI:", 40);
    String domyslnyAdresURI = "/servlet/cwp.ShowParameters";
    poleAdresuURI.getTextField().setText(domyslnyAdresURI);
    panelWejsciowy.add(poleAdresuURI);
    Canvas separator2 = new Canvas();
    panelWejsciowy.add(separator2);
    przyciskWyslij = new Button("Wyslj dane");
    przyciskWyslij.addActionListener(this);
    Panel buttonPanel = new Panel();
    buttonPanel.add(przyciskWyslij);
    panelWejsciowy.add(buttonPanel);
    add(panelWejsciowy, BorderLayout.NORTH);
    obszarWyniku = new TextArea();
    obszarWyniku.setFont(new Font("Monospaced", Font.PLAIN, 14));
    obszarWyniku.setText(komunikatWynikowy);
    add(obszarWyniku, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent event) {
    try {
      String protokol = biezacaStrona.getProtocol();
      String serwer = poleNazwySerwera.getTextField().getText();
      String ciagPortu = poleNumeruPortu.getTextField().getText();
      int port;
      try {
        port = Integer.parseInt(ciagPortu);
      } catch(NumberFormatException nfe) {
        port = -1; // domyslny port o numerze 80
      }
      String uri = poleAdresuURI.getTextField().getText();
      URL daneURL = new URL(protokol, serwer, port, uri);
      URLConnection polaczenie = daneURL.openConnection();
      
      // Upewnij sie ze przegladarka nie umieszcza adresu URL w buforze pamieci podrecznej.
      polaczenie.setUseCaches(false);
      
      // Nakaz przegladarce umozliwienie wysylania danych do serwera.
      polaczenie.setDoOutput(true);
      
      ByteArrayOutputStream strumienBinarny =
        new ByteArrayOutputStream(512); // Rozszerz bufor w razie potrzeby
      // Strumien zapisujacy do bufora
      PrintWriter out = new PrintWriter(strumienBinarny, true);
      String danePost =
        "firstName=" + wartoscZakodowana(poleImienia) +
        "&lastName=" + wartoscZakodowana(poleNazwiska) +
        "&emailAddress=" + wartoscZakodowana(poleAdresuEmail);
      
      // Zapisz dane przesylane za pomoca metody POST do lokalnego bufora danych
      out.print(danePost);
      out.flush(); // Oproznij bufor jawnie poniewaz wykorzystana zostala metoda print, a nie println

      // Zadania POST wymagaja okreslenia naglowka  Content-Length
      String ciagDlugosci =
        String.valueOf(strumienBinarny.size());
      polaczenie.setRequestProperty
        ("Content-Length", ciagDlugosci);
      
      // Przegladarka Netscape ustawia automatycznie naglowek Content-Type i nadaje mu wartosc multipart/form-data
      // Jesli wiec przesylasz zwykle dane formularza musisz zmienic jego wartosc
      // na application/x-www-form-urlencoded, co z kolei
      // stanowi wartosc domyslna ustawiana przez przegladarke Internet Explorer. Jesli przesylasz
      // dane POST zapisane przy uzyciu strumienia ObjectOutputStream,
      // wartosc naglowka Content-Type nie jest brana pod uwage, dlatego tez
      // moglbys go pominac.
      polaczenie.setRequestProperty
        ("Content-Type", "application/x-www-form-urlencoded");
      
      // Zapisz dane POST do rzeczywistego strumienia wyjsciowego
      strumienBinarny.writeTo(polaczenie.getOutputStream());

      BufferedReader in =
        new BufferedReader(new InputStreamReader
                             (polaczenie.getInputStream()));
      String wiersz;
      String znakKoncaWiersza = "\n";
      obszarWyniku.setText("");
      while((wiersz = in.readLine()) != null) {
        obszarWyniku.append(wiersz);
        obszarWyniku.append(znakKoncaWiersza);
      }
    } catch(IOException ioe) {
      // Zapisz informacje testowe na konsoli Javy
      System.out.println("IOException: " + ioe);
    }
  }
  
  // Obiekt klasy LabeledTextField jest w rzeczywistosci obiektem klasy Panel 
  // z umieszczonym nan obiektami klasy Label oraz
  // TextField.Ponizsza metoda pobiera wartosc umieszczona w polu tekstowym,
  // nastepnie koduje ja przy uzyciu metody URL-encoded i zwraca uzyskany wynik.
  
  private String wartoscZakodowana(LabeledTextField pole) {
    String wartoscOryginalna = pole.getTextField().getText();
    return(URLEncoder.encode(wartoscOryginalna));
  }
    
}
