import java.awt.*;

/** Pole tekstowe posiadajace skojarzona z nim etykiete
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class LabeledTextField extends Panel {
  private Label label;
  private TextField textField;
  
  public LabeledTextField(String labelString,
                          Font labelFont,
                          int textFieldSize,
                          Font textFont) {
    setLayout(new FlowLayout(FlowLayout.LEFT));
    label = new Label(labelString, Label.RIGHT);
    if (labelFont != null)
      label.setFont(labelFont);
    add(label);
    textField = new TextField(textFieldSize);
    if (textFont != null)
      textField.setFont(textFont);
    add(textField);
  }

  public LabeledTextField(String labelString,
                          String textFieldString) {
    this(labelString, null, textFieldString,
         textFieldString.length(), null);
  }

  public LabeledTextField(String labelString,
                          int textFieldSize) {
    this(labelString, null, textFieldSize, null);
  }
  
  public LabeledTextField(String labelString,
                          Font labelFont,
                          String textFieldString,
                          int textFieldSize,
                          Font textFont) {
    this(labelString, labelFont,
         textFieldSize, textFont);
    textField.setText(textFieldString);
  }

  /** Etykieta umieszczona jest po lewej stronie pola.
   *  W celu modyfikacji etykiety, wykonaj odpowiednio:
   *  <PRE>
   *    LabeledTextField ltf = new LabeledTextField(...);
   *    ltf.getLabel().DowolnaMetodaDoZmianyEtykiety(...);
   *  </PRE>
   *
   * @see #getTextField
   */
  
  public Label getLabel() {
    return(label);
  }

  /** Pole tekstowe umieszczone jest po prawej stronie etykiety
   *
   * @see #getLabel
   */
  
  public TextField getTextField() {
    return(textField);
  }
}
