package cwp;

import java.io.*; 
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet tworzacy tablice lancuchow znakowych z zapytaniami
 *  i wysylajacy je przy uzyciu obiektu klasy ObjectOutputStream do apletu
 *  lub innego klienta napisanego w jezyku Java.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class QueryGenerator extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    boolean uzyjNumerowania = true;
    String znacznikNumerowania =
      request.getParameter("useNumbering");
    if ((znacznikNumerowania == null) ||
        znacznikNumerowania.equals("false")) {
      uzyjNumerowania = false;
    }
    String typZawartosci =
      "application/x-java-serialized-object";
    response.setContentType(typZawartosci);
    ObjectOutputStream out =
      new ObjectOutputStream(response.getOutputStream());
    String[] zapytania = getZapytania(uzyjNumerowania);
    // Jesli wysylasz niestandardowe struktury danych upewnij sie ze
    // okresliles implementacje interfejsu serializacji "implements Serializable".
    out.writeObject(zapytania);
    out.flush();
  }

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }

  private String[] getZapytania(boolean uzyjNumerowania) {
    String[] zapytania = new String[50];
    for(int i=0; i<zapytania.length; i++) {
      zapytania[i] = losoweZapytanie();
      if (uzyjNumerowania) {
        zapytania[i] = "" + (i+1) + ": " + zapytania[i];
      }
    }
    return(zapytania);
  }

  // Rzeczywiste zapytania wysylane przez ludzi :-)
  
  private String losoweZapytanie() {
    String[] polozenie = { "Gdzie  ", "W jaki sposob " };
    String[] czynnosc =
      { "moge odszukac ", "moge znalezc ", "moge pobrac " };
    String[] zrodlo =
      { "informacje ", "zasoby ", "dane ", "odwolania " };
    String[] przyimek = { "na temat ", "odnoszace sie do ", "dotyczace " };
    String[] temat =
      { "ksiazki Serwisy internetowe.Programowanie",
        "tekstu opisujacego serwlety oraz strony JSP",
        "serwletow oraz stron JavaServer Pages",
        "serwletow oraz stron JSP",
        "ksiazki Serwisy internetowe.Programowanie (Wydanie 2)",
        " Serwisy internetowe.Programowanie (Wydanie 2)",
        "programowania serwletow", "technologii JavaServer Pages", "stron JSP",
        "alternatywny metod programowania CGI przy uzyciu jezyka Java", "programow w jezyku Java dzialajacych po stronie serwera" };
    String[] zakonczenie = { "?", "?", "?", "?!", "?!!!?" };
    String[][] szablonyZdan =
      { polozenie, czynnosc, zrodlo,
        przyimek, temat, zakonczenie };
    String zapytanie = "";
    for(int i=0; i<szablonyZdan.length; i++) {
      zapytanie = zapytanie + losowyElement(szablonyZdan[i]);
    }
    return(zapytanie);
  }

  private String losowyElement(String[] lancuchy) {
    int indeks = (int)(Math.random()*lancuchy.length);
    return(lancuchy[indeks]);
  }
}
