import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

/** Aplet odczytujacy tablice lancuchow znakowych
 *  utworzona przez obiekt klasy QueryCollection i umieszczajacy ja w obszarze
 *  TextArea. Klasa QueryCollection przesyla dane przy uzyciu serializacji.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class ShowQueries extends Applet
                         implements ActionListener, Runnable {
  private TextArea obszarZapytan;
  private Button przyciskStart, przyciskStop, przyciskCzysc;
  private QueryCollection biezaceZapytania;
  private QueryCollection kolejneZapytania;
  private boolean isUruchomiony = false;
  private String adres =
    "/servlet/cwp.QueryGenerator";
  private URL biezacaStrona;
  
  public void init() {
    setBackground(Color.white);
    setLayout(new BorderLayout());
    obszarZapytan = new TextArea();
    obszarZapytan.setFont(new Font("Serif", Font.PLAIN, 14));
    add(obszarZapytan, BorderLayout.CENTER);
    Panel panelPrzyciskow = new Panel();
    Font czcionkaPrzycisku = new Font("SansSerif", Font.BOLD, 16);
    przyciskStart = new Button("Start");
    przyciskStart.setFont(czcionkaPrzycisku);
    przyciskStart.addActionListener(this);
    panelPrzyciskow.add(przyciskStart);
    przyciskStop = new Button("Stop");
    przyciskStop.setFont(czcionkaPrzycisku);
    przyciskStop.addActionListener(this);
    panelPrzyciskow.add(przyciskStop);
    przyciskCzysc = new Button("Czysc");
    przyciskCzysc.setFont(czcionkaPrzycisku);
    przyciskCzysc.addActionListener(this);
    panelPrzyciskow.add(przyciskCzysc);
    add(panelPrzyciskow, BorderLayout.SOUTH);
    biezacaStrona = getCodeBase();
    // Zada zestawu przykladowych zapytan. Sa one pobierane
    // przy uzyciu watku dzialajacego w tle zas aplet sprawdza czy jego dzialanie
    // zostalo zakonczone
    // przed podjeciem proby pobrania lancuchow znakowych.
    biezaceZapytania = new QueryCollection(adres, biezacaStrona);
    kolejneZapytania = new QueryCollection(adres, biezacaStrona);
  }

  /** Jesli wcisniesz przycisk "Start" system
   *  uruchomi watek dzialajacy w tle wyswietlajacy zapytania w obszarze
   *  tekstowym. Wcisniecie "Stop"
   *  zatrzymuje dzialanie procesu, zas "Czysc" oproznia
   *  obszar tekstowy.
   */
 
  public void actionPerformed(ActionEvent event) {
    if (event.getSource() == przyciskStart) {
      if (!isUruchomiony) {
        Thread procesWyswietlajacy = new Thread(this);
        isUruchomiony = true;
        obszarZapytan.setText("");
        procesWyswietlajacy.start();
        showStatus("Proces wywietlajcy zapytania zosta uruchomiony...");
      } else {
        showStatus("Proces wywietlajcy zapytania ju dziaa...");
      }
    } else if (event.getSource() == przyciskStop) {
      isUruchomiony = false;
      showStatus("Proces wywietlajcy zapytanai zosta zatrzymany...");
    } else if (event.getSource() == przyciskCzysc) {
      obszarZapytan.setText("");
    }
  }

  /** Proces dzialajacy w tle pobiera obiekt biezaceZapytania
   *  i co pol sekundy umieszcza jedno z przechowywanych w nim zapytan
   *  na dole obszaru tekstowego. Po wyswietleniu wszystkich zapytan
   *  watek kopiuje zawartosc obiektu
   *  kolejneZapytania object do obiektu
   *  biezaceZapytania, wysyla nowe zadanie do serwera
   *  w celu ponownego zapelnienia obiektu kolejneZapytania, i powtarza caly proces
   */

  public void run() {
    while(isUruchomiony) {
      pokazZapytania(biezaceZapytania);
      biezaceZapytania = kolejneZapytania;
      kolejneZapytania = new QueryCollection(adres, biezacaStrona);
    }
  }

  private void pokazZapytania(QueryCollection zbiorZapytan) {
    // Jesli zadanie zostalo wyslane do serwera lecz nie zwrocil on jeszcze wynikow
    // wtedy sprawdzaj co sekunde czy zadanie zostalo ukonczone
    // Powinno zdarzac sie dosc rzadko, lecz moze wystepowac w przypadku bardzo wolnych
    // polaczen sieciowych lub przeciazonych serwerow.
    while(!zbiorZapytan.isKoniec()) {
      showStatus("Oczekiwanie na dane z serwera...");
      pauza(1);
    }
    showStatus("Otrzymano dane z serwera...");
    String[] zapytania = zbiorZapytan.getZapytania();
    String znakkoncawiersza = "\n";
    // umiesc nowy ciag zapyytania w obszarze tekstowym co pol sekundy.
    for(int i=0; i<zapytania.length; i++) {
      if (!isUruchomiony) {
        return;
      }
      obszarZapytan.append(zapytania[i]);
      obszarZapytan.append(znakkoncawiersza);
      pauza(0.5);
    }
  }

  public void pauza(double seconds) {
    try {
      Thread.sleep((long)(seconds*1000));
    } catch(InterruptedException ie) {}
  }
}
