import java.net.*;
import java.io.*;

/** Po utworzeniu tej klasy, zwraca ona natychmiast wartosc, 
 *  w przypadku metody getZapytania jest to wartosc null, za w przypadku isZakonczone wartosc false
 *  W miedzyczasie zostaje utworzony watek sluzacy do pobrania ciagow zapytan z serwera
 *  odczytywanych z jednym zamachem przy uzyciu obiektu klasy 
 *  ObjectInputStream. Po pobraniu ciagow zapytan sa one umieszczane w zmiennej
 *  odczytywanej przez metode getZapytania,
 *  zas wartosc znacznika isZakonczone zostaje zmieniona na true.
 *  Klasa wykorzystywana przez aplet ShowQueries.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;  
 */

public class QueryCollection implements Runnable {
  private String[] zapytania;
  private String[] tymczasoweZapytania;
  private boolean isKoniec = false;
  private URL daneAdresuURL;

  public QueryCollection(String przyrostekURL, URL biezacaStrona) {
    try {
      // Only the URL suffix need be supplied, since
      // the rest of the URL is derived from the current page.
      String protokol = biezacaStrona.getProtocol();
      String host = biezacaStrona.getHost();
      int port = biezacaStrona.getPort();
      daneAdresuURL = new URL(protokol, host, port, przyrostekURL);
      Thread watekPobierajacyZapytania = new Thread(this);
      watekPobierajacyZapytania.start();
    } catch(MalformedURLException mfe) {
      isKoniec = true;
    }
  }

  public void run() {
    try {
      tymczasoweZapytania = pobierzZapytania();
      zapytania = tymczasoweZapytania;
    } catch(IOException ioe) {
      tymczasoweZapytania = null;
      zapytania = null;
    }
    isKoniec = true;
  }

  public String[] getZapytania() {
    return(zapytania);
  }

  public boolean isKoniec() {
    return(isKoniec);
  }

  private String[] pobierzZapytania() throws IOException {
    URLConnection polaczenie = daneAdresuURL.openConnection();
    // Upewnij sie ze przegladarka nie umieszcza tego adresu URL w pamieci podrecznej
    // Pragniemy przeciez uzyskac rozne  zapytania dla kazdego zadania.
    polaczenie.setUseCaches(false);
    // Uzyj ObjectInputStream tak aby mozliwe bylo jednorazowe odczytanie String[]
    ObjectInputStream in =
      new ObjectInputStream(polaczenie.getInputStream());
    try {
      // metoda readObject zwraca obiekt
      // dlatego konieczne jest zrzutowanie do na rzeczywisty obiekt
      String[] ciagiZapytan = (String[])in.readObject();
      return(ciagiZapytan);
    } catch(ClassNotFoundException cnfe) {
      return(null);
    }
  }
}
