import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

/** Aplet odczytujacy wartosc umieszczona w polu edycyjnym,
 *  a nastepnie tworzacy przy jej uzyciu  trzy rozne adresy URL
 *  zawierajace osadzone dane GET: po jednym dla wyszukiwarek Google, Infoseek, oraz Lycos.
 *  Nastepnie adresy te przekazywane sa do przegladarki
 *  wyswietlajacej wyniki wyszukiwania w trzech oddzielnych ramkach.
 *  Zwroc uwage, ze zwykle formularze HTML nie sa w stanie w sposob automatyczny
 *  wysylac wielu jednoczesnych zapytan.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class SearchApplet extends Applet
                          implements ActionListener {
  private TextField poleZapytania;
  private Button przyciskZatwierdzajacy;

  public void init() {
    setBackground(Color.white);
    setFont(new Font("Serif", Font.BOLD, 18));
    add(new Label("Poszukiwany cig:"));
    poleZapytania = new TextField(40);
    poleZapytania.addActionListener(this);
    add(poleZapytania);
    przyciskZatwierdzajacy = new Button("Wylij do wyszukiwarek");
    przyciskZatwierdzajacy.addActionListener(this);
    add(przyciskZatwierdzajacy);
  }

  /** Wysyla dane w przypadku wcisniecia przycisku <B>lub</B>
   *  uzycia klawisza Return w polu tekstowym.
   */
  
  public void actionPerformed(ActionEvent event) {
    String zapytanie = URLEncoder.encode(poleZapytania.getText());
    SearchSpec[] glowneAdresy = SearchSpec.pobierzGlowneAdresy();
    // Pominiety zostal adres HotBot (ostatni wpis), poniewaz w celu wyswietlenia wynikow
    // wyszukiwarka ta uzywa kodu w jezyku JavaScript. Dlatego tez ponizej wystepuje wyrazenie length-1 .
    for(int i=0; i<glowneAdresy.length-1; i++) {
      try {
        SearchSpec adres = glowneAdresy[i];
        // Klasa SearchSpec tworzy adresy URL
        // w postaci wymaganej przez kilka roznych powszechnie uzywanych wyszukwiarek internetowych.
        URL searchURL = new URL(adres.utworzAdresURL(zapytanie, "10"));
        String nazwaRamki = "results" + i;
        getAppletContext().showDocument(searchURL, nazwaRamki);
      } catch(MalformedURLException mue) {}
    }
  }
}
