package cwp.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;

/** Tworzy naglowek HTML z okreslonym kolorem tla
 *  kolorem tekstu, wyrownaniem, czcionka, oraz rozmiarem czcionki.
 *  Mozliwe jest rowniez narysowanie ramki wokol naglowka, ktora normalnie zawiera jedynie
 *  naglowek lecz moze tez zostac rozszerzona do szerokosci calej strony.
 *  Wszystkie atrybuty za wyjatkiem koloru tla sa opcjonalne.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class HeadingTag extends TagSupport {
  private String bgColor; // Jedyny wymagany atrybut
  private String color = null;
  private String align="CENTER";
  private String fontSize="36";
  private String fontList="Arial, Helvetica, sans-serif";
  private String border="0";
  private String width=null;
  
  public void setBgColor(String bgColor) {
    this.bgColor = bgColor;
  }

  public void setColor(String color) {
    this.color = color;
  }
  
  public void setAlign(String align) {
    this.align = align;
  }
  
  public void setFontSize(String fontSize) {
    this.fontSize = fontSize;
  }

  public void setFontList(String fontList) {
    this.fontList = fontList;
  }

  public void setBorder(String border) {
    this.border = border;
  }

  public void setWidth(String width) {
    this.width = width;
  }
  
  public int doStartTag() {
    try {
      JspWriter out = pageContext.getOut();
      out.print("<TABLE BORDER=" + border +
                " BGCOLOR=\"" + bgColor + "\"" +
                " ALIGN=\"" + align + "\"");
      if (width != null) {
        out.print(" WIDTH=\"" + width + "\"");
      }
      out.print("><TR><TH>");
      out.print("<SPAN STYLE=\"" +
                "font-size: " + fontSize + "px; " +
                "font-family: " + fontList + "; ");
      if (color != null) {
        out.println("color: " + color + ";");
      }
      out.print("\"> "); // koniec <SPAN ...>
    } catch(IOException ioe) {
      System.out.println("Bd w HeadingTag: " + ioe);
    }
    return(EVAL_BODY_INCLUDE); // Dolacz zawartosc znacznika
  }

  public int doEndTag() {
    try {
      JspWriter out = pageContext.getOut();
      out.print("</SPAN></TABLE>");
    } catch(IOException ioe) {
      System.out.println("Bd w HeadingTag: " + ioe);
    }
    return(EVAL_PAGE); // Kontynuuj dalsza czesc strony JSP
  }
}
