package cwp.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import cwp.*;

/** Znacznik zastepujacy znaki <, >, ", oraz & encjami
 *  uzywanymi w kodzie HTML (&lt;, &gt;, &quot;, oraz &amp;).
 *  Po dokonaniu filtrowania w zawartosci oraz atrybutach HTML
 *  moga byc umieszczane dowolne lancuchy znakowe.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class FilterTag extends BodyTagSupport {
  public int doAfterBody() {
    BodyContent tresc = getBodyContent();
    String trescPrzefiltrowana =
      NarzedziaSerwletow.filtruj(tresc.getString());
    try {
      JspWriter out = tresc.getEnclosingWriter();
      out.print(trescPrzefiltrowana);
    } catch(IOException ioe) {
      System.out.println("Bd w FilterTag: " + ioe);
    }
    // SKIP_BODY oznacza zakonczenie operacji. Jesli zawartosc znacznika ma zostac przetworzona ponownie
    // wtedy powinna zostac zwrocona stala EVAL_BODY_TAG.
    return(SKIP_BODY);
  }
}
