package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet wysokiego poziomu symulujacy podroz. Ten serwlet ustawia dane
 *  klienta jako ziarno, nastepnie przekazuje zadanie do 
 *  strony rezerwacji lini lotniczych, wypozyczalni samochodow
 *  rezerwacji miejsc w hotelach, strony modyfikacji danych uzytkownika
 *  lub do strony sluzacej do utworzenia nowego konta.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown; 
 */

public class Travel extends HttpServlet {
  private TravelCustomer[] travelData;

  public void init() {
    travelData = TravelData.getTravelData();
  }

  /** Poniewaz wysylane jest haslo uzyj metody POST. Tym niemniej,
   *  uzycie tej metody oznacza ze zadanie nie moze zostac przekazane 
   *  do statycznej strony HTML, poniewaz uzywana jest wtedy ta sama metoda co
   *  podczas pierwotnego wywolania, a strony statyczne
   *  nie moga obslugiwac metod typu POST. Rozwiazanie:
   *  nadaj statycznym stronom rozszerzenie JSP
   *  na przyklad accounts.jsp. Inne strony
   *  JSP musz juz byc generowane w sposob automatyczny poniewaz,
   *  uzywaja danych klienta.
   */
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    String emailAddress = request.getParameter("emailAddress");
    String password = request.getParameter("password");
    TravelCustomer customer =
      TravelCustomer.findCustomer(emailAddress, travelData);
    if ((customer == null) || (password == null) ||
        (!password.equals(customer.getPassword()))) {
      gotoPage("/travel/accounts.jsp", request, response);
    }
    // Metody uzywajace przekazanych wartosc
    // sprawdza ich obecnosc oraz poprawnosc.
    customer.setStartDate(request.getParameter("startDate"));
    customer.setEndDate(request.getParameter("endDate"));
    customer.setOrigin(request.getParameter("origin"));
    customer.setDestination(request.getParameter
                              ("destination"));
    HttpSession session = request.getSession(true);
    session.setAttribute("customer", customer);
    if (request.getParameter("flights") != null) {
      gotoPage("/travel/BookFlights.jsp",
               request, response);
    } else if (request.getParameter("cars") != null) {
      gotoPage("/travel/RentCars.jsp",
               request, response);
    } else if (request.getParameter("hotels") != null) {
      gotoPage("/travel/FindHotels.jsp",
               request, response);
    } else if (request.getParameter("cars") != null) {
      gotoPage("/travel/EditAccounts.jsp",
               request, response);
    } else {
      gotoPage("/travel/IllegalRequest.jsp",
               request, response);
    }
  }
  
  private void gotoPage(String address,
                        HttpServletRequest request,
                        HttpServletResponse response)
      throws ServletException, IOException {
    RequestDispatcher dispatcher =
      getServletContext().getRequestDispatcher(address);
    dispatcher.forward(request, response);
  }
}
