import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Klasa JPanel posiadajca panel z tekstem wypisanym pod rnymi ktami
 *  w grnej czci okna oraz komponent klasy JComboBox zawierajcy
 *  mozliwe do wybrania czcionki.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class PanelTekstowy extends JPanel
                       implements ActionListener {
  private JComboBox wyborCzcionki;
  private DrawingPanel panelRysowania;
  
  public PanelTekstowy() {
    GraphicsEnvironment env =
      GraphicsEnvironment.getLocalGraphicsEnvironment();
    String[] nazwyCzcionek = env.getAvailableFontFamilyNames();
    wyborCzcionki = new JComboBox(nazwyCzcionek);
    setLayout(new BorderLayout());
    JPanel panelCzcionki = new JPanel();
    panelCzcionki.add(new JLabel("Czcionka:"));
    panelCzcionki.add(wyborCzcionki);
    JButton przyciskRysowania = new JButton("Rysuj");
    przyciskRysowania.addActionListener(this);
    panelCzcionki.add(przyciskRysowania);
    add(panelCzcionki, BorderLayout.SOUTH);
    panelRysowania = new DrawingPanel();
    wyborCzcionki.setSelectedItem("Serif");
    panelRysowania.ustawNazweCzcionki("Serif");
    add(panelRysowania, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent e) {
    panelRysowania.ustawNazweCzcionki((String)wyborCzcionki.getSelectedItem());
    panelRysowania.repaint();
  }
}
