package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

/** Serwlet pobierajcy poszukiwany cig, maksymaln liczb wynikw na stronie
 *  oraz nazw wyszukiwarki internetowej oraz wysyajcy zapytanie do wyszukiwarki internetowej.
 *  Przykad ten ilustruje sposb modyfikacji
 *  wiersza nagwka odpowiedzi. W przypadku gdy uzyska znan nazw wyszukiwarki wysya kod 302
 *  (powodujcy przekierowanie zapytania) ,
 *  a w innym przypadku kod 404 (bd dania).
 */

public class Wyszukiwarki extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String poszukiwanyCiag = request.getParameter("searchString");
    if ((poszukiwanyCiag == null) ||
        (poszukiwanyCiag.length() == 0)) {
      zglosProblem(response, "Nie zostal okreslony poszukiwany ciag.");
      return;
    }
    // Obiekt URLEncoder zmienia spacje na znaki "+" 
    // za inne nie alfanumeryczne znaki na znaki postaci  "%XY", gdzie XY jest
    // wartoci szesnastkow kodu ASCII (lub ISO Latin-1).
    // Przegldarki zawsze koduj w ten sposb dane formularza,
    // dlatego te metoda getParameter powoduje ich automatyczne odkodowanie. Poniewa jednak
    // przekazujemy cig do innego serwera, naley je ponownie zakodowa
    poszukiwanyCiag = URLEncoder.encode(poszukiwanyCiag);
    String liczbWynikow = request.getParameter("numResults");
    if ((liczbWynikow == null) ||
        (liczbWynikow.equals("0")) ||
        (liczbWynikow.length() == 0)) {
      liczbWynikow = "10";
    }
    String wyszukiwarka =
      request.getParameter("searchEngine");
    if (wyszukiwarka == null) {
      zglosProblem(response, "Niez zostala okreslona nazwa wyszukiwarki.");
      return;
    }
    Wyszukanie[] glowneAdresy = Wyszukanie.pobierzGlowneAdresy();
    for(int i=0; i<glowneAdresy.length; i++) {
      Wyszukanie adres = glowneAdresy[i];
      if (adres.pobierzNazwe().equals(wyszukiwarka)) {
        String url =
          adres.utworzAdresURL(poszukiwanyCiag, liczbWynikow);
        response.sendRedirect(url);
        return;
      }
    }
    zglosProblem(response, "Wyszukiwarka nie zostala rozpoznana.");
  }

  private void zglosProblem(HttpServletResponse response,
                             String komunikat)
      throws IOException {
    response.sendError(response.SC_NOT_FOUND,
                       "<H2>" + komunikat + "</H2>");
  }

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
