package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Ustawia sze plikw cookie: trzy z nich maj zastosowanie jedynie w przypadku biecej sesji
 *   (niezalenie od dugoci jej trwania),
 *  za trzy pozostae trwaj godzin (niezalenie od tego,
 *  czy przegldarka zostanie ponownie uruchomiona).
 *  <P>
 * Kody zaczerpnite z polskiej edycji
 * ksiki Serwisy internetowe. Programowanie
 * Wydawnictwo Helion, Gliwice,
 * ftp://ftp.helion.pl/przyklady/serinp.zip
 * 2001 Marty Hall and Larry Brown;
 */

public class UstawCookies extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    for(int i=0; i<3; i++) {
      // Domylny czas ycia cookie wynosi -1, co wskazuje,
      // e ma ono zastosowanie jedynie w przypadku biecej sesji.
      Cookie ciasteczko = new Cookie("Cookie-sesji-" + i,
                                 "Wartosc-cookie-S" + i);
      response.addCookie(ciasteczko);
      ciasteczko = new Cookie("Cookie-trwale-" + i,
                          "Wartosc-cookie-T" + i);
      // Cookie wane jest przez godzin, niezalenie od tego, czy
      // uytkownik zamknie przegladark, uruchomi ponownie komputer lub uczyni co innego.
      ciasteczko.setMaxAge(3600);
      response.addCookie(ciasteczko);
    }
    response.setContentType("text/html");
    PrintWriter wyjscie = response.getWriter();
    String tytul = "Ustawianie cookies";
    wyjscie.println
      (NarzedziaSerwletow.headOrazTitle(tytul) +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H1 ALIGN=\"CENTER\">" + tytul + "</H1>\n" +
       "Na tej stronie istnieje sze cookies.\n" +
       "W celu ich ujrzenia uruchom serwlet \n" +
       "<A HREF=\"/servlet/cwp.PokazCookies\">\n" +
       "<CODE>ShowCookies</CODE></A>.\n" +
       "<P>\n" +
       "Trzy z ciasteczek skojarzone s jedynie \n" +
       "z biec sesj, podczas gdy trzy pozostae s trwae.\n" +
       "W celu zweryfikowania tego faktu zamknij przegldark, uruchom j ponownie i powr do serwletu\n" +
       "<CODE>PokazCookies</CODE>. \n" +
       "</BODY></HTML>");
  }
}
