package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.zip.*;

/** Przykad ukazujcy korzyci wynikajce z wysyania skompresowanych stron
 *  do przegldarki obsugujcej format gzip.
*/

public class SkompresowanaStrona extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html");
    String rodzajeKodowania = request.getHeader("Accept-Encoding");
    String znacznikKodowania = request.getParameter("encoding");
    PrintWriter wyjscie;
    String tytul;
    if ((rodzajeKodowania != null) &&
        (rodzajeKodowania.indexOf("gzip") != -1) &&
        !"none".equals(znacznikKodowania)) {
      tytul = "Strona zakodowana za pomoca GZip";
      OutputStream wyjscie1 = response.getOutputStream();
      wyjscie = new PrintWriter(new GZIPOutputStream(wyjscie1), false);
      response.setHeader("Content-Encoding", "gzip");
    } else {
      tytul = "Zwykla strona";
      wyjscie = response.getWriter();
    }
    wyjscie.println(NarzedziaSerwletow.headOrazTitle(tytul) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + tytul + "</H1>\n");
    String line = "Bla, bla, bla, bla, bla. " +
                  "bla, bla, bla, bla.";
    for(int i=0; i<10000; i++) {
      wyjscie.println(line);
    }
    wyjscie.println("</BODY></HTML>");
    wyjscie.close();
  }
}
