package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;
import java.util.*;

/** Prosty przykad ledzenia sesji.
 */

public class PokazSesje extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html");
    PrintWriter wyjscie = response.getWriter();
    String tytul = "Przykad ledzenia sesji";
    HttpSession sesja = request.getSession(true);
    String naglowek;
    Integer liczbaOdwiedzin =
      (Integer)sesja.getAttribute("accessCount");
    if (liczbaOdwiedzin == null) {
      liczbaOdwiedzin = new Integer(0);
      naglowek = "Witaj przybyszu";
    } else {
      naglowek = "Witaj ponownie";
      liczbaOdwiedzin = new Integer(liczbaOdwiedzin.intValue() + 1);
    }
    // w wersji 2.2 uywamy setAttribute zamiast putValue
    sesja.setAttribute("accessCount", liczbaOdwiedzin);

    wyjscie.println(NarzedziaSerwletow.headOrazTitle(tytul) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + naglowek + "</H1>\n" +
                "<H2>Informacje o sesji:</H2>\n" +
                "<TABLE BORDER=1 ALIGN=\"CENTER\">\n" +
                "<TR BGCOLOR=\"#FFAD00\">\n" +
                "  <TH>Rodzaj informacji<TH>Warto\n" +
                "<TR>\n" +
                "  <TD>ID\n" +
                "  <TD>" + sesja.getId() + "\n" +
                "<TR>\n" +
                "  <TD>Czas utworzenia\n" +
                "  <TD>" +
                new Date(sesja.getCreationTime()) + "\n" +
                "<TR>\n" +
                "  <TD>Czas ostatniego odwoania\n" +
                "  <TD>" +
                new Date(sesja.getLastAccessedTime()) + "\n" +
                "<TR>\n" +
                "  <TD>Liczba poprzednich odwiedzin\n" +
                "  <TD>" + liczbaOdwiedzin + "\n" +
                "</TABLE>\n" +
                "</BODY></HTML>");

  }

  /** Obsu metody GET oraz POST w sposb identyczny. */

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
