package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Wywietla wszystkie nagwki dania.
 */

public class PokazNaglowki extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html");
    PrintWriter wyjscie = response.getWriter();
    String title = "Przykad serwletu: Wywietlanie nagwkw dania";
    wyjscie.println(NarzedziaSerwletow.headOrazTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + title + "</H1>\n" +
                "<B>Metoda dania: </B>" +
                request.getMethod() + "<BR>\n" +
                "<B>Adres URI dania: </B>" +
                request.getRequestURI() + "<BR>\n" +
                "<B>Protok dania: </B>" +
                request.getProtocol() + "<BR><BR>\n" +
                "<TABLE BORDER=1 ALIGN=\"CENTER\">\n" +
                "<TR BGCOLOR=\"#FFAD00\">\n" +
                "<TH>Nazwa nagwka<TH>Warto nagwka");
    Enumeration nazwyNaglowkow = request.getHeaderNames();
    while(nazwyNaglowkow.hasMoreElements()) {
      String nazwaNaglowka = (String)nazwyNaglowkow.nextElement();
      wyjscie.println("<TR><TD>" + nazwaNaglowka);
      wyjscie.println("    <TD>" + request.getHeader(nazwaNaglowka));
    }
    wyjscie.println("</TABLE>\n</BODY></HTML>");
  }

  /** Sprawmy, aby ten sam serwlet obsugiwa dania GET oraz POST. */

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
