package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Przykad przedstawiajcy inicjacj serwletu Komunikat, ktry ma zosta wywietlony oraz
 *  ilo jego powtrze
 *  pobierane s z parametrw inicjacyjnych.
  */

public class PokazKomunikat extends HttpServlet {
  private String komunikat;
  private String domyslnyKomunikat = "Brak komunikatu.";
  private int liczbaPowtorzen = 1;

  public void init() throws ServletException {
    ServletConfig konfiguracja = getServletConfig();
    komunikat = konfiguracja.getInitParameter("message");
    if (komunikat == null) {
      komunikat = domyslnyKomunikat;
    }
    try {
      String ciagLiczbyPowtorzen = konfiguracja.getInitParameter("repeats");
      liczbaPowtorzen = Integer.parseInt(ciagLiczbyPowtorzen);
    } catch(NumberFormatException nfe) {
      // Wyjtek NumberFormatException obsuguje przypadek, w ktrym
      // ciagLiczbyPowtorzen ma warto null lub nieprawidowy format.
    }
  }

  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
        throws ServletException, IOException {
    response.setContentType("text/html");
    PrintWriter wyjscie = response.getWriter();
    String tytul = "Serwlet pokazujcy komunikat";
    wyjscie.println(NarzedziaSerwletow.headOrazTitle(tytul) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + tytul + "</H1>");
    for(int i=0; i<liczbaPowtorzen; i++) {
      wyjscie.println("<B>" + komunikat + "</B><BR>");
    }
    wyjscie.println("</BODY></HTML>");
  }
}
