package cwp;

import java.math.BigInteger;

/** Kilka narzedzi do tworzenia duych losowych liczb cakowitych
 *  i odnajdywania kolejnej liczby pierwszej wikszej ni podana liczba.
 *  <P>
 * Kody zaczerpnite z polskiej edycji
 * ksiki Serwisy internetowe. Programowanie
 * Wydawnictwo Helion, Gliwice,
 * ftp://ftp.helion.pl/przyklady/serinp.zip
 * 2001 Marty Hall and Larry Brown;
 */

public class Pierwsze {
  // Zauwa, e BigInteger.ZERO zostao wprowadzone w JDK 1.2 oraz kod w wersji 1.1
  // bdzie wykonany przez wikszo moduw obsugujcych serwlety
  private static final BigInteger ZERO = new BigInteger("0");
  private static final BigInteger JEDEN = new BigInteger("1");
  private static final BigInteger DWA = new BigInteger("2");

  // Prawdopodobiestwo uzyskania bdnej liczby pierwszej jest mniejsze ni 1/2^WAR_BLEDU
  private static final int WAR_BLEDU = 100;

  public static BigInteger nastepnaPierwsza(BigInteger start) {
    if (jestParzysta(start))
      start = start.add(JEDEN);
    else
      start = start.add(DWA);
    if (start.isProbablePrime(WAR_BLEDU))
      return(start);
    else
      return(nastepnaPierwsza(start));
  }

  private static boolean jestParzysta(BigInteger n) {
    return(n.mod(DWA).equals(ZERO));
  }

  private static StringBuffer[] cyfry =
    { new StringBuffer("0"), new StringBuffer("1"),
      new StringBuffer("2"), new StringBuffer("3"),
      new StringBuffer("4"), new StringBuffer("5"),
      new StringBuffer("6"), new StringBuffer("7"),
      new StringBuffer("8"), new StringBuffer("9") };

  private static StringBuffer losowaCyfra() {
    int indeks = (int)Math.floor(Math.random() * 10);
    return(cyfry[indeks]);
  }

  public static BigInteger losowa(int liczbaCyfr) {
    StringBuffer s = new StringBuffer("");
    for(int i=0; i<liczbaCyfr; i++) {
      s.append(losowaCyfra());
    }
    return(new BigInteger(s.toString()));
  }

  /** Prosty program wywoywany z wiersza polece sucy do testowania. 
   *  Wprowad ilo cyfr, a nastpnie pobierz losow liczb i wyswietl pierwszych
   *  50 liczb pierwszych od niej wikszych
   */

  public static void main(String[] args) {
    int liczbaCyfr;
    if (args.length > 0)
      liczbaCyfr = Integer.parseInt(args[0]);
    else
      liczbaCyfr = 150;
    BigInteger start = losowa(liczbaCyfr);
    for(int i=0; i<50; i++) {
      start = nastepnaPierwsza(start);
      System.out.println("Liczba Pierwsza " + i + " = " + start);
    }
  }
}
