package cwp;

import javax.servlet.*;
import javax.servlet.http.*;

/** Kilka prostych funkcji oszczdzajcych czas. Zauwa, e wikszo z nich to metody statyczne.
 */

public class NarzedziaSerwletow {
  public static final String DOCTYPE =
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
    "Transitional//EN\">";

  public static String headOrazTitle(String tytul) {
    return(DOCTYPE + "\n" +
           "<HTML>\n" +
           "<HEAD><TITLE>" + tytul + "</TITLE></HEAD>\n");
  }

  /** Ponisza metoda pobiera cig znakw, a nastpnie zastpuje wszystkie wystpienia
     *  '<' cigiem '&lt;', wszystkie wystpienia '>' cigiem
     *  '&gt;', oraz (w celu obsugi przypadkw wystpujcych wewntrz nazw atrybutw),
     *  wszystkie wystpienia cudzysoww cigiem
     *  '&quot;' wszystkie wystpienia '&' cigiem '&amp;'.
     *  Bez tego rodzaju filtrowania dowolny cig
     *  nie mgby by w sposb bezpieczny wstawiony na stronie WWW.
     */

    public static String filtruj(String daneWejsciowe) {
      StringBuffer danePrzefiltrowane = new StringBuffer(daneWejsciowe.length());
      char c;
      for(int i=0; i<daneWejsciowe.length(); i++) {
        c = daneWejsciowe.charAt(i);
        if (c == '<') {
          danePrzefiltrowane.append("&lt;");
        } else if (c == '>') {
          danePrzefiltrowane.append("&gt;");
        } else if (c == '"') {
          danePrzefiltrowane.append("&quot;");
        } else if (c == '&') {
          danePrzefiltrowane.append("&amp;");
        } else {
          danePrzefiltrowane.append(c);
        }
      }
      return(danePrzefiltrowane.toString());
    }
   /** Odczytuje parametr z okrelon nazw konwertuje go na warto int
      *  i zwraca. W przypadku gdy parametr nie istnieje lub ma zy format, zwraca domyln warto.
     */

     public static int dajParametrInt(HttpServletRequest request,
                                       String nazwaParametru,
                                       int wartoscDomyslna) {
       String lancuchParametru = request.getParameter(nazwaParametru);
       int wartoscParametru;
       try {
         wartoscParametru = Integer.parseInt(lancuchParametru);
       } catch(NumberFormatException nfe) { // null lub nieprawidowy format
         wartoscParametru = wartoscDomyslna;
       }
       return(wartoscParametru);
     }

   /** Metoda ta pobiera tablic cookies, nazw oraz domyln warto, a nastpnie
      *  prbuje odnale warto cookie o podanej nazwie.
      *  Jeli w tablicy brak jest cookie o podanej nazwie,
      *  w zamian zwracana jest warto domylna.
      */

     public static String dajWartoscCookie(Cookie[] ciasteczka,
                                           String nazwaCiasteczka,
                                           String wartoscDomyslna) {
       if (ciasteczka != null) {
         for(int i=0; i<ciasteczka.length; i++) {
           Cookie ciasteczko = ciasteczka[i];
           if (nazwaCiasteczka.equals(ciasteczko.getName()))
             return(ciasteczko.getValue());
         }
       }
       return(wartoscDomyslna);
     }

     /** Ponisza metoda pobiera tablic cookies oraz nazw, a nastpnie
      *  prbuje zwrci odnalezione w tablicy cookie o podanej nazwie.
      *  Jeli w tablicy brak jest cookie o podanej nazwie,
      *  zwracana jest warto null.
      */

     public static Cookie dajCookie(Cookie[] ciasteczka,
                                    String nazwaCiasteczka) {
       if (ciasteczka != null) {
         for(int i=0; i<ciasteczka.length; i++) {
           Cookie ciasteczko = ciasteczka[i];
           if (nazwaCiasteczka.equals(ciasteczko.getName()))
             return(ciasteczko);
         }
       }
       return(null);
     }

}
