package cwp;

import java.util.*;
import java.math.BigInteger;

/** Tworzy wektor zawierajcy due liczby pierwsze, dziaajc zazwyczaj
 *  w procesie ta o niskim priorytecie. Udostpnia kilka metod dostpu.
 *  <P>
 * Kody zaczerpnite z polskiej edycji
 * ksiki Serwisy internetowe. Programowanie
 * Wydawnictwo Helion, Gliwice,
 * ftp://ftp.helion.pl/przyklady/serinp.zip
 * 2001 Marty Hall and Larry Brown;
 */

public class ListaLiczbPierwszych implements Runnable {
  private Vector odnalezionePierwsze;
  private int liczbaPierwszych, liczbaCyfr;

  /** Odnajduje liczbaPierwszych liczb pierwszych, z ktrych kada
   *  ma minimum liczbaCyfr cyfr.
   */

  public ListaLiczbPierwszych(int liczbaPierwszych, int liczbaCyfr,
                   boolean uruchomWTle) {
    // Uywa Vector zamiast ArrayList
    // w celu obsugi serwletw w wersji JDK 1.1
    odnalezionePierwsze = new Vector(liczbaPierwszych);
    this.liczbaPierwszych = liczbaPierwszych;
    this.liczbaCyfr = liczbaCyfr;
    if (uruchomWTle) {
      Thread t = new Thread(this);
      // Uywa niskiego priorytetu, aby nie obcia zbytnio serwera.
      t.setPriority(Thread.MIN_PRIORITY);
      t.start();
    } else {
      run();
    }
  }

  public void run() {
    BigInteger start = Pierwsze.losowa(liczbaCyfr);
    for(int i=0; i<liczbaPierwszych; i++) {
      start = Pierwsze.nastepnaPierwsza(start);
      synchronized(this) {
        odnalezionePierwsze.addElement(start);
      }
    }
  }

  public synchronized boolean zrobione() {
    return(odnalezionePierwsze.size() == liczbaPierwszych);
  }

  public synchronized Vector pobierzPierwsze() {
    if (zrobione())
      return(odnalezionePierwsze);
    else
      return((Vector)odnalezionePierwsze.clone());
  }

  public int liczbaCyfr() {
    return(liczbaCyfr);
  }

  public int liczbaPierwszych() {
    return(liczbaPierwszych);
  }

  public synchronized int liczbaObliczonychPierwszych() {
    return(odnalezionePierwsze.size());
  }
}
