package cwp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Serwlet przetwarzajcy danie wygenerowania n
 *  liczb pierwszych, z ktrych kada zawiera bdzie przynajmniej m cyfr.
 *  Wykonuje obliczenia w wtku dziaajcym w tle, o niskim priorytecie,
 *  zwracajc jedynie znalezione dotd wyniki.
 *  Jeli nie s one kompletne, wysya do przegldarki nagwek Refresh
 *  nakazujcy jej odwieenie strony po krtkiej przerwie.
 *  Przechowuje rwnie krtk list poprzednio
 *  obliczonych liczb pierwszych w celu natychmiastowego zwrcenia
 *  wyniku w przypadku podania przez uytkownika
 *  tych samych wartoci n oraz m, co w przypadku poprzednich oblicze.
 *  <P>
 * Kody zaczerpnite z polskiej edycji
 * ksiki Serwisy internetowe. Programowanie
 * Wydawnictwo Helion, Gliwice,
 * ftp://ftp.helion.pl/przyklady/serinp.zip
 * 2001 Marty Hall and Larry Brown;
 */

public class LiczbyPierwsze extends HttpServlet {
  private Vector wektorLiczbPierwszych = new Vector();
  private int dlugoscListy = 30;

  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    int liczbaPierwszych =
      NarzedziaSerwletow.dajParametrInt(request,
                                       "numLiczbyPierwsze", 50);
    int liczbaCyfr =
      NarzedziaSerwletow.dajParametrInt(request,
                                       "numCyfry", 120);
    ListaLiczbPierwszych listaPierwszych =
      znajdzListePierwszych(wektorLiczbPierwszych, liczbaPierwszych, liczbaCyfr);
    if (listaPierwszych == null) {
      listaPierwszych = new ListaLiczbPierwszych(liczbaPierwszych, liczbaCyfr, true);
      // Wiele wtkw obsugi da dzieli te same zmienne egzemplarza
      //  (pola) klasy PrimeNumbers. Dlatego te konieczna jest
      // synchronizacja dostpu do pl serwletu.
      synchronized(wektorLiczbPierwszych) {
        if (wektorLiczbPierwszych.size() >= dlugoscListy)
          wektorLiczbPierwszych.removeElementAt(0);
        wektorLiczbPierwszych.addElement(listaPierwszych);
      }
    }
    Vector biezacePierwsze = listaPierwszych.pobierzPierwsze();
    int liczbaBiezacychPierwszych = biezacePierwsze.size();
    int liczbaPozostalychPierwszych = (liczbaPierwszych - liczbaBiezacychPierwszych);
    boolean czyOstatniWynik = (liczbaPozostalychPierwszych == 0);
    if (!czyOstatniWynik) {
      response.setHeader("Refresh", "5");
    }
    response.setContentType("text/html");
    PrintWriter wyjscie = response.getWriter();
    String title = "Niektre " + liczbaCyfr + "-cyfrowe liczby pierwsze";
    wyjscie.println(NarzedziaSerwletow.headOrazTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H2 ALIGN=CENTER>" + title + "</H2>\n" +
                "<H3>Odnalezione" + liczbaCyfr +
                " cyfrowe liczby pierwsze: " + liczbaBiezacychPierwszych +
                ".</H3>");
    if (czyOstatniWynik)
      wyjscie.println("<B>Poszukiwanie zakoczone.</B>");
    else
      wyjscie.println("<B>Wci poszukuj " + liczbaPozostalychPierwszych +
                  " liczb<BLINK>...</BLINK></B>");
    wyjscie.println("<OL>");
    for(int i=0; i<liczbaBiezacychPierwszych; i++) {
      wyjscie.println("  <LI>" + biezacePierwsze.elementAt(i));
    }
    wyjscie.println("</OL>");
    wyjscie.println("</BODY></HTML>");
  }

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }

  // Sprawd, czy istniej trwajce lub ukoczone obliczenia
  // dotyczce tej samej iloci liczb pierwszych, o takiej samej iloci cyfr.
  // W takim przypadku zamiast rozpoczyna nowy wtek dziaajcy w tle,
  // zwr poprzednie wyniki. Lista ta powinna by maa,
  // tak aby serwer WWW nie zuywa zbyt wiele pamici.
  // Konieczne jest zsynchronizowanie dostpu do listy, poniewa moe istnie
  // wiele jednoczesnych da.

  private ListaLiczbPierwszych znajdzListePierwszych(Vector wektorLiczbPierwszych,
                                  int liczbaPierwszych,
                                  int liczbaCyfr) {
    synchronized(wektorLiczbPierwszych) {
      for(int i=0; i<wektorLiczbPierwszych.size(); i++) {
        ListaLiczbPierwszych liczbyPierwsze =
          (ListaLiczbPierwszych)wektorLiczbPierwszych.elementAt(i);
        if ((liczbaPierwszych == liczbyPierwsze.liczbaPierwszych()) &&
            (liczbaCyfr == liczbyPierwsze.liczbaCyfr()))
          return(liczbyPierwsze);
      }
      return(null);
    }
  }
}
