import java.net.*;
import java.io.*;

/** Wielowtkowa wersja klasy SerwerEcho. 
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class WielowatkowySerwerEcho extends SerwerEcho
                                implements Runnable {
  public static void main(String[] args) {
    int port = 8088;
    if (args.length > 0) {
      try {
        port = Integer.parseInt(args[0]);
      } catch(NumberFormatException nfe) {}
    }
    WielowatkowySerwerEcho serwerEcho =
      new WielowatkowySerwerEcho(port, 0, "Wielowatkowy SerwerEcho");
  }

  public WielowatkowySerwerEcho(int port, int maksLiczbaPolaczen, String nazwa) {
    super(port, maksLiczbaPolaczen, nazwa);
  }

  /** Nowa wersja metody obsluzPolaczenie uruchamia wtek. 
   *  Stworzony wtek wywouje <I>star</I> wersj metody 
   *  obsluzPolaczenie, co w efekcie daje takie samo zachowanie 
   *  serwera w wersji wielowtkowej. Wtek przechowuje obiekt 
   *  gniazda poniewa metoda run nie przyjmuje adnych argumentw
   *  i poniewa przechowujc gniazdo w zmiennej lokalnej ryzykujemy,
   *  e zostania ona nadpisana, jeli kolejny wtek bdzie uruchomiony
   *  zanim metoda run bdzie miaa szans na odczytanie poprzedniej 
   *  wartoci. 
   */
                                  
  public void obsluzPolaczenie(Socket serwer) {
    Polaczenie watekPolaczenia = new Polaczenie(this, serwer);
    watekPolaczenia.start();
  }
    
  public void run() {
    Polaczenie biezacyWatek =
      (Polaczenie)Thread.currentThread();
    try {
      super.obsluzPolaczenie(biezacyWatek.podajGniazdo());
    } catch(IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }
}

/** Klasa Thread rozszerzona o pole przechowujce obiekt gniazda.
 *  Umoliwia bezpieczne dla wielowtkowoci przekazanie gniazda 
 *  z metody obsluzPolaczenie do run.
 */

class Polaczenie extends Thread {
  private Socket gniazdoSerwera;

  public Polaczenie(Runnable obiektSerwera,
                    Socket gniazdoSerwera) {
    super(obiektSerwera);
    this.gniazdoSerwera = gniazdoSerwera;
  }
  
  public Socket podajGniazdo() {
    return gniazdoSerwera;
  }
}