import java.net.*;
import java.io.*;
import java.util.StringTokenizer;

/** Prosty serwer HTTP generujcy stron zawierajc wszystkie informacje
 *  otrzymane od klienta WWW (przewanie jest to przegldarka).
 *  Aby uy ten serwer naley uruchomi go w wybranym systemie, 
 *  przekazujc numer portu jeli ma by on inny ni port 8088. 
 *  Nazwijmy ten system serwer.com. Nastpnie w tym samym lub innym
 *  systemie uruchamiamy przegldark internetow i czymy si z adresem
 *  http://serwer.com:8088/cokolwiek. Otrzymana strona bdzie 
 *  zawieraa wszystkie informacje przesane przez przegldark. 
 *  Podczas testowanie serwletw lub programw CGI adres 
 *  http://serwer.com:8088/cokolwiek jako warto atrybutu ACTION 
 *  dla formularza HTML. Dane mog by wysyane zarwno przy uyciu metody 
 *  GET jak i POST -- w obu przypadkach generowana strona ujawni wszystkie
 *  dane wysane przez przegldark.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class SerwerEcho extends SerwerSieciowy {
  protected int maksLiczbaWierszyZadania = 50;
  protected String nazwaSerwera;

  /** Numer portu moe zosta przekazany przez argument
   *  wiersza polece. W przeciwnym razie uywa portu 8088.
   */
  
  public static void main(String[] args) {
    int port = 8088;
    if (args.length > 0) {
      try {
        port = Integer.parseInt(args[0]);
      } catch(NumberFormatException nfe) {}
    }
    new SerwerEcho(port, 0, "SerwerEcho");
  }

  public SerwerEcho(int port, int maksLiczbaPolaczen, String nazwa) {
    super(port, maksLiczbaPolaczen);
    nazwaSerwera = nazwa;
    nasluchuj();
  }

  /** Nadpisuje metod obsluzPolaczenie klasy bazowej SerwerSieciowy,
   *  tak aby odczytywaa wszystkie wiersze otrzymanych danych
   *  zachowujc je w tablicy acuchw i odesaa z powrotem
   *  umieszczone na stronie HTML wewntrz elementu PRE.
   */
  
  public void obsluzPolaczenie (Socket serwer)
      throws IOException{
    System.out.println
        (nazwaSerwera + ": got connection from " +
         serwer.getInetAddress().getHostName());
    BufferedReader wejscie = NarzedziaSieciowe.podajCzytnik(serwer);
    PrintWriter wyjscie = NarzedziaSieciowe.podajPisarz(serwer);
    String[] wierszeWejsciowe = new String[maksLiczbaWierszyZadania];
    int i;
    for (i=0; i<maksLiczbaWierszyZadania; i++) {
      wierszeWejsciowe[i] = wejscie.readLine();
      if (wierszeWejsciowe[i] == null) // Klient zamkn poczenie.
        break;
      if (wierszeWejsciowe[i].length() == 0) { // Wiersz pusty.
        if (uzytaMetodaPost(wierszeWejsciowe)) {
          odczytajDanePost(wierszeWejsciowe, i, wejscie);
          i = i + 2;
        }
        break;
      }
    }
    drukujNaglowek(wyjscie);
    for (int j=0; j<i; j++) {
      wyjscie.println(wierszeWejsciowe[j]);
    }
    drukujStopke(wyjscie);
    serwer.close();
  }

  // Wysya standardow odpowied HTTP i nagwek zwykej strony WWW.
  // Uywamy HTTP 1.0 dla zachowania zgodnoci ze wszystkimi klientami.
  
  private void drukujNaglowek(PrintWriter wyjscie) {
    wyjscie.println
      ("HTTP/1.0 200 OK\r\n" +
       "Server: " + nazwaSerwera + "\r\n" +
       "Content-Type: text/html\r\n" +
       "\r\n" +
       "<!DOCTYPE HTML PUBLIC " +
         "\"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
       "<HTML>\n" +
       "<HEAD>\n" +
       "  <TITLE>" + nazwaSerwera + " wyniki </TITLE>\n" +
       "</HEAD>\n" +
       "\n" +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H1 ALIGN=\"CENTER\">" + nazwaSerwera +
         " wyniki </H1>\n" +
       "Poniej znajduje si wiersz dania oraz nagwki dania\n" +
       "wysane przez przegldark:\n" +
       "<PRE>");
  }

  // Wypisz zakoczenie zwykej strony WWW.
  
  private void drukujStopke(PrintWriter wyjscie) {
    wyjscie.println
      ("</PRE>\n" +
       "</BODY>\n" +
       "</HTML>\n");
  }

  // Zwyke dania strony WWW uywaj metody GET, dziki czemu serwer
  // moe odczyta dane wiersz po wierszu. Jednak w przypadku formularzy HTML
  // uyta moe zosta take metoda POST, a wtedy konieczne jest okrelenie
  // liczby wysanych bajtw eby dowiedzie si jak duo danych spodziewa si
  // poniej standardowych nagwkw HTTP.
  
  private boolean uzytaMetodaPost(String[] daneWejsciowe) {
    return(daneWejsciowe[0].toUpperCase().startsWith("POST"));
  }

  private void odczytajDanePost(String[] daneWejsciowe, int i,
                            BufferedReader wejscie)
      throws IOException {
    int dlugoscZawartosci = dlugoscZawartosci(daneWejsciowe);
    char[] danePost = new char[dlugoscZawartosci];
    wejscie.read(danePost, 0, dlugoscZawartosci);
    daneWejsciowe[++i] = new String(danePost, 0, dlugoscZawartosci);
  }

  // Majc dany wiersz rozpoczynajcy si od Content-Length
  // metoda zwraca przekazan warto liczbow.
  
  private int dlugoscZawartosci(String[] daneWejsciowe) {
    String wierszWejsciowy;
    for (int i=0; i<daneWejsciowe.length; i++) {
      if (daneWejsciowe[i].length() == 0)
        break;
      wierszWejsciowy = daneWejsciowe[i].toUpperCase();
      if (wierszWejsciowy.startsWith("CONTENT-LENGTH"))
        return(podajDlugosc(wierszWejsciowy));
    }
    return(0);
  }

  private int podajDlugosc(String dlugosc) {
    StringTokenizer analizator = new StringTokenizer(dlugosc);
    analizator.nextToken();
    return(Integer.parseInt(analizator.nextToken()));
  }
}