import java.rmi.*; // Dla klas Naming, RemoteException, itd.
import java.net.*; // Dla klas MalformedURLException
import java.io.*;  // Dla klas Serializable interface

/** Pobiera obiekt implementujcy interfejs Zdalny z podanego serwera.
 *  Wywouje jego metody tak samo jak dla obiektu lokalnego.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class ZdalnyKlient {
  public static void main(String[] args) {
    try {
      String serwer =
        (args.length > 0) ? args[0] : "localhost";
      // Pobierz zdalny obiekt i zachowaj go w zmiennej obiektZdalny:
      Zdalny obiektZdalny = 
        (Zdalny)Naming.lookup("rmi://" + serwer + "/Zdalny");
      // Wywoaj metody dla obiektZdalny:
      System.out.println(obiektZdalny.podajWiadomosc());
    } catch(RemoteException re) {
      System.out.println("RemoteException: " + re);
    } catch(NotBoundException nbe) {
      System.out.println("NotBoundException: " + nbe);
    } catch(MalformedURLException mfe) {
      System.out.println("MalformedURLException: " + mfe);
    }
  }
}