import java.rmi.*;
import java.net.*;
import java.io.*; 

/** Wersja klasy KlientZdalnaCalka dla platformy Java 2,
 *  ktra wyznacza klientowi obowizek zainstalowania 
 *  menadera bezpieczestwa, aby mg on czy si z 
 *  maszyn zdaln w celu zaadowania plikw namiastki
 *  i wykonania cakowania numerycznego przy uyciu 
 *  zdalnego obiektu.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */


public class KlientZdalnaCalka2 {
  public static void main(String[] args) {
    try {
      System.setSecurityManager(new RMISecurityManager());
      String serwer = (args.length > 0) ? args[0] : "localhost";
      ZdalnaCalka zdalnaCalka =
        (ZdalnaCalka)Naming.lookup("rmi://" + serwer +
                                      "/ZdalnaCalka");
      for(int krokow=10; krokow<=10000; krokow*=10) {
        System.out.println
          ("Przyblizenie w " + krokow + " krokach:" +
           "\n  Calka od 0 do pi z sin(x)=" +
           zdalnaCalka.calkuj(0.0, Math.PI,
                                    krokow, new Sin()) +
           "\n  Calka od pi/2 do pi z cos(x)=" +
           zdalnaCalka.calkuj(Math.PI/2.0, Math.PI,
                                    krokow, new Cos()) +
           "\n  Calka od 0 do 5 z x^2=" +
           zdalnaCalka.calkuj(0.0, 5.0, krokow,
                                    new Kwadratowa()));
      }
      System.out.println
        ("`Poprawne' odpowiedzi obliczone za pomoca biblioteki Math:" +
         "\n  Calka od 0 do pi z sin(x)=" +
         (-Math.cos(Math.PI) - -Math.cos(0.0)) +
         "\n  Calka od pi/2 do pi z cos(x)=" +
         (Math.sin(Math.PI) - Math.sin(Math.PI/2.0)) +
         "\n  Calka od 0 do 5 z x^2=" +
         (Math.pow(5.0, 3.0) / 3.0));
    } catch(RemoteException re) {
      System.out.println("RemoteException: " + re);
    } catch(NotBoundException nbe) {
      System.out.println("NotBoundException: " + nbe);
    } catch(MalformedURLException mfe) {
      System.out.println("MalformedURLException: " + mfe);
    }
  }
}