/** Klasa wykonujca sumowanie i cakowanie numeryczne.
 *  Caka obliczana jest za pomoc metody prostoktw.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class Calka {
  /** Zwraca sum wartoci f(x) w punktach od x=start do x=stop, 
   *  gdzie funkcja f jest okrelana przez metod oblicz obiektu  
   *  Wyliczalny.
   */

  public static double zsumuj(double start, double stop,
                              double rozmiarKroku,
                              Wyliczalny objWylicz) {
    double suma = 0.0, biezaca = start;
    while (biezaca <= stop) {
      suma += objWylicz.oblicz(biezaca);
      biezaca += rozmiarKroku;
    }
    return(suma);
  }

  /** Zwraca przyblion warto caki f(x) w granicach od
   *  start do stop, obliczon za pomoc metody prostoktw. 
   *  Funkcja f jest definiowana przez metod oblicz 
   *  obiektu Wyliczalny.
   */
  
  public static double calkuj(double start, double stop,
                              int liczbaKrokow, 
                              Wyliczalny objWylicz) {
    double rozmiarKroku = (stop - start) / (double)liczbaKrokow;
    start = start + rozmiarKroku / 2.0;
    return(rozmiarKroku * zsumuj(start, stop, rozmiarKroku, objWylicz));
  }
}