import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.net.*;
import java.io.*;
import javax.swing.*;

/** Klasa KlientZdalnaCalka zaimplementowana jako aplet
 *  ktry laczy sie ze zdalnym komputerem w celu obliczenia
 *  calek numerycznych dla funkcji sinus, cosinus i kwadratowej.
 *  Jako aplet klasa posiada wlasnego menadzera bezpieczenstwa
 *  i nie trzeba instalowac RMISecurityManager aby mc zaladowac
 *  klasy namiastki.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class ApletZdalnaCalka extends JApplet
                                  implements ActionListener {
  private Wyliczalny[] funkcje;
  private ZdalnaCalka zdalnaCalka;
  private JLabel wynik;
  private JTextField poleStart, poleStop, poleKroki;
  private JComboBox wyborFunkcji;

  public void init() {
    String serwer = getCodeBase().getHost();
    try {
      zdalnaCalka =
        (ZdalnaCalka)Naming.lookup("rmi://" + serwer +
                                      "/ZdalnaCalka");
    } catch(RemoteException re) {
      zglosBlad("RemoteException: " + re);
    } catch(NotBoundException nbe) {
      zglosBlad("NotBoundException: " + nbe);
    } catch(MalformedURLException mfe) {
      zglosBlad("MalformedURLException: " + mfe);
    }

    Container zawartosc = getContentPane();
    // Dodaj pole wyboru.
    funkcje = new Wyliczalny[]{ new Sin(),
                                new Cos(),
                                new Kwadratowa() };
    wyborFunkcji = new JComboBox(funkcje);
    zawartosc.add(wyborFunkcji, BorderLayout.NORTH);

    // Dodaj pola wejsciowe.
	poleStart = new JTextField();
    poleStop = new JTextField();
    poleKroki = new JTextField();
    wynik = new JLabel();
    JPanel panelEtykiet = new JPanel(new GridLayout(4,1));
    panelEtykiet.add(new JLabel("Start:"));
    panelEtykiet.add(new JLabel("Stop:"));
    panelEtykiet.add(new JLabel("Kroki:"));
    panelEtykiet.add(new JLabel("Wynik:  "));
    zawartosc.add(panelEtykiet, BorderLayout.WEST);
    JPanel panelDanych = new JPanel(new GridLayout(4,1));
    panelDanych.add(poleStart);
    panelDanych.add(poleStop);
    panelDanych.add(poleKroki);
    panelDanych.add(wynik);
    zawartosc.add(panelDanych, BorderLayout.CENTER);

    // Dodaj przycisk.
    JPanel panelPrzycisku = new JPanel(new FlowLayout());
    JButton oblicz = new JButton("Oblicz");
    oblicz.addActionListener(this);
    panelPrzycisku.add(oblicz);
    zawartosc.add(panelPrzycisku, BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent event) {
    try {
      int liczbaKrokow = Integer.parseInt(poleKroki.getText());
      double start = Double.parseDouble(poleStart.getText());
      double stop = Double.parseDouble(poleStop.getText());
      showStatus("Obliczam ...");
      Wyliczalny funkcja = (Wyliczalny)wyborFunkcji.getSelectedItem();
      double pole = zdalnaCalka.calkuj(start, stop,
                                             liczbaKrokow, funkcja);
      wynik.setText(Double.toString(pole));
      showStatus("");
    } catch(NumberFormatException nfe) {
      zglosBlad("Bdne dane: " + nfe);
    } catch(RemoteException re) {
      zglosBlad("RemoteException: " + re);
    }
  }

  private void zglosBlad(String message) {
    System.out.println(message);
    showStatus(message);
  }
}