import java.net.*;  
import java.io.*;

/** Majc dany adres e-mail w postaci uytkownik@serwer,
 *  pocz si z portem 25 tego serwera i wylij danie
 *  'expn' dla podanego uytkownika. Wywietl odpowied.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class WeryfikatorAdresow extends KlientSieciowy {
  private String nazwauzytkownika;

  public static void main(String[] args) {
    if (args.length != 1) {
      skladnia();
   }
    AdresPocztowy adres = new AdresPocztowy(args[0]);
    WeryfikatorAdresow weryfikator
      = new WeryfikatorAdresow(adres.podajNazweUzytkownika(),
                            adres.podajNazweSerwera(), 25);
    weryfikator.polacz();
  }

  public WeryfikatorAdresow(String nazwauzytkownika, String nazwaserwera,
                         int port) {
    super(nazwaserwera, port);
    this.nazwauzytkownika = nazwauzytkownika;
  }

  /** Klasa nadrzdna KlientSieciowy automatycznie ustanawia poczenie
   *  i przekazuje obiekt gniazda do metody obsluzPolaczenie.
   *  Ta metoda jest odpowiedzialna za wszystkie operacje 
   *  konieczne do porozumienia z serwerem. 
   */
  
  // Nie moemy uy metody readLine, poniewa powoduje ona zablokowanie 
  // wykonania. Blokowanie operacji wejcia/wyjcia jest wskazane  
  // tylko w sytuacji, kiedy wiadomo ile wierszy ma zosta przeczytane.
  // Natomiast serwery pocztowe po nawizaniu poczenia wysyaj
  // rn liczb wierszy i nie wysyaj wiersza koczcego poczenie 
  // (tak jak robi to serwery HTTP), co skutkuje zwrceniem 
  // wartoci null przez readLine. Zakadamy, e 1000 bajtw 
  // a nadto wystarczy, aby odebra tekst powitania serwera oraz 
  // faktyczn odpowied na polecenie EXPN.
  
  protected void obsluzPolaczenie(Socket klient) {
    try {
      PrintWriter wyjscie = NarzedziaSieciowe.podajPisarz(klient);
      InputStream wejscie = klient.getInputStream();
      byte[] odpowiedz = new byte[1000];
      // Pomi powitanie serwera pocztowego.
      wejscie.read(odpowiedz);
      wyjscie.println("EXPN " + nazwauzytkownika);
      // Odczytaj odpowied na polecenie EXPN.
      int liczbaBajtow = wejscie.read(odpowiedz);
      // Tutaj 0 oznacza zwyke kodowanie ASCII.
      System.out.write(odpowiedz, 0, liczbaBajtow);
      wyjscie.println("QUIT");
      klient.close();
    } catch(IOException ioe) {
      System.out.println("Nie udalo sie nawiazac polaczenia: " + ioe);
    }
  }
  
  /** Jeli podane zostay ze argumenty, wywietl ostrzeenie. */
  
  public static void skladnia() {
    System.out.println("Prosze podac adres poczty elektronicznej " +
       "w postaci 'nazwauzytkownika@serwera'.");
    System.exit(-1);
  }
}