import java.net.*;

/** Odczytuje adres URL z wiersza polece i wywietla
 *  jego poszczeglne skadniki.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class TestUrl {
  public static void main(String[] args) {
    if (args.length == 1) {
      try {
        URL url = new URL(args[0]);
        System.out.println
          ("URL: " + url.toExternalForm() + "\n" +
           "  Plik:     " + url.getFile() + "\n" +
           "  Serwer:   " + url.getHost() + "\n" +
           "  Port:     " + url.getPort() + "\n" +
           "  Protokol: " + url.getProtocol() + "\n" +
           "  Odnosnik: " + url.getRef());
      } catch(MalformedURLException mue) {
        System.out.println("Nie prawidlowy URL.");
      }
    } else
      System.out.println("Sklasnia: TestUrl <URL>");
  }
}