import java.net.*;
import java.io.*;

/** Klasa bazowa dla serwerw sieciowych. We wasnym serwerze konieczne 
 *  jest nadpisanie metody obsluzPolaczenie, ale metoda nasluchuj zazwyczaj 
 *  pozostaje niezmieniona. Wykorzystuje klas NarzedziaSieciowe 
 *  upraszczajc tworzenie obiektw PrintWriter i BufferedReader.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class SerwerSieciowy {
  private int port, maksLiczbaPolaczen;

  /** Tworzy serwer na nasuchujcy wskazanym porcie. Serwer bdzie 
   *  przyjmowa poczenia i przekazywa kade do metody obsluzPolaczenie  
   *  a wysane zostanie bezporednie polecenie wyjcia (np. System.exit) 
   *  lub osignita zostanie maksymalna liczba pocze. Jeli serwer
   *  ma dziaa w nieskoczono to naley ustawi warto 0 dla
   *  waciwoci maksLiczbaPolaczen.
   */
  
  public SerwerSieciowy(int port, int maksLiczbaPolaczen) {
    ustawPort(port);
    ustawMaksLiczbePolaczen(maksLiczbaPolaczen);
  }

  /** Monitoruje wskazany port na przychodzce poczenie. Po nawizaniu
   *  poczenia przekazuje otrzymane gniazdo do metody obsluzPolaczenie .
   */
  
  public void nasluchuj() {
    int i=0;
    try {
      ServerSocket nasluch = new ServerSocket(port);
      Socket serwer;
      while((i++ < maksLiczbaPolaczen) || (maksLiczbaPolaczen == 0)) {
        serwer = nasluch.accept();
        obsluzPolaczenie (serwer);
      }
    } catch (IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }

  /** Ta metoda definiuje zachowanie serwera, poniewa okrela 
   *  co ma si sta z otrzymanym gniazdem. <B>Tworzc nowy serwer 
   *  naley nadpisa t metod.</B>
   *  <P>
   *  Wersja oglna zgasza jedynie nazw komputera, z ktrego 
   *  nadeszo poczenie, wywietla pierwszy wiersz wysany przez klienta
   *  i odsya jeden wiersz w odpowiedzi.
   */

  protected void obsluzPolaczenie (Socket serwer)
      throws IOException{
    BufferedReader wejscie = NarzedziaSieciowe.podajCzytnik(serwer);
    PrintWriter wyjscie = NarzedziaSieciowe.podajPisarz(serwer);
    System.out.println
      ("Ogolny serwer sieciowy:\nprzyjeto polaczenie od " +
       serwer.getInetAddress().getHostName() + "\n" +
       "pierwszy otrzymany wiersz '" + wejscie.readLine() + "'");
    wyjscie.println("Ogolny serwer sieciowy");
    serwer.close();
  }

  /** Zwraca maksymalna liczb pocze, jak serwer obsuy 
   *  przed przerwaniem dziaania. Podanie wartoci 0 
   *  oznacza, e serwer bdzie dziaa dopki nie zostanie
   *  bezporednio zatrzymany.
   */

  public int podajMaksLiczbePolaczen() {
    return(maksLiczbaPolaczen);
  }

  /** Ustawia maksymaln liczb pocze. Warto 0 oznacza, e
   *  serwer bdzie dziaa w nieskoczono (dopki nie zostanie
   *  bezporednio zatrzymany).
   */

  public void ustawMaksLiczbePolaczen(int maksLiczbaPolaczen) {
    this.maksLiczbaPolaczen = maksLiczbaPolaczen;
  }

  /** Podaje numer portu, na ktrym serwer nasuchuje. */

  public int podajPort() {
    return(port);
  }

  /** Ustawia numer portu. <B>Numer portu mona zmieni tylko przed
   *  wywoaniem "pocz".</B> Najczciej ustawia si go w konstruktorze.
   */

  protected void ustawPort(int port) {
    this.port = port;
  }
}