import java.net.*;
import java.io.*;

/** Klasa upraszczajca tworzenie obiektw BufferedReaders i
 *  PrintWriters powizanych z podanym gniazdem sieciowym.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class NarzedziaSieciowe {
  /** Tworzy czytnik BufferedReader sucy do pobierania przychodzcych danych. */

  public static BufferedReader podajCzytnik(Socket s)
      throws IOException {
    return(new BufferedReader(
       new InputStreamReader(s.getInputStream())));
  }

  /** Tworzy pisarza PrintWriter sucego do wysyania danych wychodzcych.
   *  Utworzony PrintWriter bdzie automatycznie oprnia bufor strumienia
   *  przy kadym wywoaniu metody println.
   */

  public static PrintWriter podajPisarz(Socket s)
      throws IOException {
    // Drugi parametr powoduje automatyczne oprnianie bufora.
    return(new PrintWriter(s.getOutputStream(), true));
  }
}