import java.net.*;
import java.io.*;

/** Klasa bazowa dla klientw sieciowych. We wasnym kliencie konieczne 
 *  jest nadpisanie metody obsluzPolaczenie, ale metoda polacz zazwyczaj 
 *  pozostaje niezmieniona. Wykorzystuje klas NarzedziaSieciowe 
 *  upraszczajc tworzenie obiektw PrintWriter i BufferedReader.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class KlientSieciowy {
  protected String serwer;
  protected int port;

  /** Zarejestruj nazw serwera i numer portu. Poczenie 
   *  nie bdzie nawizane dopki nie zostanie wywoana 
   *  metoda polacz.
   */
  
  public KlientSieciowy(String serwer, int port) {
    this.serwer = serwer;
    this.port = port;
  }

  /** Ustanawia poczenie sieciowe i przekazuje gniazdo
   *  do metody obsluzPolaczenie.
   */
  
  public void polacz() {
    try {
      Socket klient = new Socket(serwer, port);
      obsluzPolaczenie(klient);
    } catch(UnknownHostException uhe) {
      System.out.println("Serwer nieznany: " + serwer);
      uhe.printStackTrace();
    } catch(IOException ioe) {
      System.out.println("Blad wejscia/wyjscia: " + ioe);
      ioe.printStackTrace();
    }
  }

  /** T metod naley nadpisa tworzc klienta sieciowego
   *  dla wasnych zada. Wersja domylna wysya do serwera 
   *  jeden wiersz danych ("Oglny Klient Sieciowy"), odczytuje
   *  jeden wiersz otrzymanej odpowiedzi, wywietla go,
   *  i na tym koczy dziaanie.
   */
  
  protected void obsluzPolaczenie(Socket klient)
    throws IOException {
    PrintWriter wyjscie = NarzedziaSieciowe.podajPisarz(klient);
    BufferedReader wejscie = NarzedziaSieciowe.podajCzytnik(klient);
    wyjscie.println("Ogolny Klient Sieciowy");
    System.out.println
      ("Ogolny Klient Sieciowy:\n" +
       "Nawiazano polaczenie z serwerem " + serwer +
       " i otrzymano w odpowiedzi '" + wejscie.readLine());
    klient.close();
  }

  /** Nazwa serwera, do ktrego bdziemy si czy. */
  
  public String podajSerwer() {
    return(serwer);
  }

  /** Numer portu, z ktrym nawizane zostanie poczenie. */
  
  public int podajPort() {
    return(port);
  }
}