import java.net.*;
import java.io.*;

/** Odczytuje plik zdalny przy uyciu standardowej klasy URL 
 *  zamiast czy si bezporednio z serwerem HTTP.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class CzytnikUrl2 {
  public static void main(String[] args) {
    sprawdzSkladnie(args);
    try {
      URL url = new URL(args[0]);
      BufferedReader wejscie = new BufferedReader(
        new InputStreamReader(url.openStream()));
      String line;
      while ((line = wejscie.readLine()) != null) {
        System.out.println("> " + line);
     }
      wejscie.close();
    } catch(MalformedURLException mue) { // konstruktor klasy URL 
        System.out.println(args[0] + " nie jest poprawnym adresem URL: " + mue);
    } catch(IOException ioe) { // konstruktory strumieni
      System.out.println("IOException: " + ioe);
    }
  }

  private static void sprawdzSkladnie(String[] args) {
    if (args.length != 1) {
      System.out.println("Skladnia: CzytnikUrl2 <URL>");
      System.exit(-1);
    }
  }
}