import java.util.*;

/** Klasa przeprowadza analiz skadniow wprowadzonego adresu 
 *  uzyskujc nazw serwera, numer portu oraz nazw pliku, 
 *  a nastepnie przekazuje te trzy wartoci do klasy CzytnikUri,
 *  ktra pobiera dokument wskazywany przez URL z sieci.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class CzytnikUrl {
  public static void main(String[] args) {
    sprawdzSkladnie(args);
    StringTokenizer analiz = new StringTokenizer(args[0]);
    String protokol = analiz.nextToken(":");
    sprawdzProtokol(protokol);
    String serwer = analiz.nextToken(":/");
    String uri;
    int port = 80;
    try {
      uri = analiz.nextToken("");
      if (uri.charAt(0) == ':') {
        analiz = new StringTokenizer(uri);
        port = Integer.parseInt(analiz.nextToken(":/"));
        uri = analiz.nextToken("");
      }
    } catch(NoSuchElementException nsee) {
      uri = "/";
    }
    CzytnikUri klientUri = new CzytnikUri(serwer, port, uri);
    klientUri.polacz();
  }

  /** Wywietl uytkownikowi ostrzeenie jeli nie poda adresu URL. */
  
  private static void sprawdzSkladnie(String[] args) {
    if (args.length != 1) {
      System.out.println("Skladnia: CzytnikUrl <URL>");
      System.exit(-1);
    }
  }

  /** Powiadom uytkownika e obsugiwany jest tylko protok HTTP. */
  
  private static void sprawdzProtokol(String protokol) {
    if (!protokol.equals("http")) {
      System.out.println("Nieznany protokol " + protokol);
      System.exit(-1);
    }
  }
}