import java.net.*;
import java.io.*;

/** Pobiera dokument wskazywany przez URL majc dane 
 *  nazw serwera, port oraz nazw pliku jako trzy oddzielne 
 *  parametry wiersza polece. Dla kolejnej klasy
 *  (CztnikUrl) wystarczy poda cay URL.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class CzytnikUri extends KlientSieciowy {
  private String uri;

  public static void main(String[] args) {
    CzytnikUri klientUri
      = new CzytnikUri(args[0], Integer.parseInt(args[1]),
                         args[2]);
    klientUri.polacz();
  }

  public CzytnikUri(String serwer, int port, String uri) {
    super(serwer, port); 
    this.uri = uri;
  }

  /** Wylij jeden wiersz dania GET, odczytaj odpowied wiersz po wierszu,
   *  i wywietl kady wiersz na standardowym wyjciu.
   */

  // W tym wypadku mona spokojnie uy blokujcych operacji wejcia/wyjcia 
  // (readLine), poniewa serwer HTTP zamyka poczenie po zakoczeniu 
  // przesyania, w zwizku z czym metoda readLine zwrci warto null.
  
  protected void obsluzPolaczenie(Socket gniazdoUri)
      throws IOException {
    PrintWriter wyjscie = NarzedziaSieciowe.podajPisarz(gniazdoUri);
    BufferedReader wejscie = NarzedziaSieciowe.podajCzytnik(gniazdoUri);
    wyjscie.println("GET " + uri + " HTTP/1.0\r\n");
    String wiersz;
    while ((wiersz = wejscie.readLine()) != null) {
      System.out.println("> " + wiersz);
    }
  }
}