import java.util.*;

/** Przyjmuje acuch w postaci "uytkownik@serwer" i 
 *  rozdziela go na czci "uytkownik" i "serwer".
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class AdresPocztowy {
  private String nazwauzytkownika, nazwaserwera;

  public AdresPocztowy(String adresPocztowy) {
    StringTokenizer analizator
      = new StringTokenizer(adresPocztowy, "@");
    this.nazwauzytkownika = odczytajSkladnik(analizator);
    this.nazwaserwera = odczytajSkladnik(analizator);
  }

  private static String odczytajSkladnik(StringTokenizer analizator) {
    try { return(analizator.nextToken()); }
    catch (NoSuchElementException nsee) {
      System.out.println("Podany adres jest nieprawidlowy");
      System.exit(-1);
      return(null);
    }
  }
  
  public String podajNazweUzytkownika() {
    return(nazwauzytkownika);
  }

  public String podajNazweSerwera() {
    return(nazwaserwera);
  }
}