import java.awt.*; // Dla klas BorderLayout, GridLayout, Font, Color.
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/** Klient graficzny, ktry umoliwia interaktywne 
 *  poczenie si z serwerem WWW i przesyanie 
 *  dowolnego poleceni dania i nagwkw dania.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class KlientWWW extends JPanel
    implements Runnable, Przerywacz, ActionListener {
  public static void main(String[] args) {
	NarzedziaOkienkowe.ustawWygladSystemowy();
    NarzedziaOkienkowe.otworzWJFrame(new KlientWWW(), 600, 700, 
                                     "Klient WWW", 
                                     SystemColor.control);
  }

  private EtykietowanePoleTekstowe poleSerwer, polePortu,
          poleWierszaZadania;
  private JTextArea poleNaglowkowZadania, poleWynikow;
  private String serwer, wierszZadania;
  private int port;
  private String[] naglowkiZadania = new String[30];
  private JButton przyciskPobierz, przyciskPrzerwij;
  private boolean wystapiloPrzerwanie = false;

  public KlientWWW() {
    setLayout(new BorderLayout(5, 30));
    int rozmiarCzcionki = 14;
    Font czcionkaEtykiety =
      new Font("Serif", Font.BOLD, rozmiarCzcionki);
    Font czcionkaNaglowka =
      new Font("SansSerif", Font.BOLD, rozmiarCzcionki+4);
    Font czcionkaTekstu =
      new Font("Monospaced", Font.BOLD, rozmiarCzcionki-2);
    JPanel panelWejsciowy = new JPanel();
    panelWejsciowy.setLayout(new BorderLayout());
    JPanel panelEtykiet = new JPanel();
    panelEtykiet.setLayout(new GridLayout(4,1));
    poleSerwer = new EtykietowanePoleTekstowe("Serwer:", czcionkaEtykiety,
                                     30, czcionkaTekstu);
    polePortu = new EtykietowanePoleTekstowe("Port:", czcionkaEtykiety,
                                     "80", 5, czcionkaTekstu);
    // Dla zgodnoci z wikszoi serwerw naley uy dania HTTP 1.0.
    // Jeli zmieniemy na 1.1, to *konieczne* jest podanie nagowka dania
    // Host: nazwa_serwera. 
    poleWierszaZadania =
      new EtykietowanePoleTekstowe("Wiersz dania:", czcionkaEtykiety,
                           "GET / HTTP/1.0", 50, czcionkaTekstu);
    panelEtykiet.add(poleSerwer);
    panelEtykiet.add(polePortu);
    panelEtykiet.add(poleWierszaZadania);
    JLabel etykietaNaglowkowZadania =
      new JLabel("Nagwki dania:");
    etykietaNaglowkowZadania.setFont(czcionkaEtykiety);
    panelEtykiet.add(etykietaNaglowkowZadania);
    panelWejsciowy.add(panelEtykiet, BorderLayout.NORTH);
    poleNaglowkowZadania = new JTextArea(5, 80);
    poleNaglowkowZadania.setFont(czcionkaTekstu);
    JScrollPane polePrzewijalneNaglowkow = 
      new JScrollPane(poleNaglowkowZadania);
    panelWejsciowy.add(polePrzewijalneNaglowkow, BorderLayout.CENTER);
    JPanel panelPrzyciskow = new JPanel();
    przyciskPobierz = new JButton("Przelij danie");
    przyciskPobierz.addActionListener(this);
    przyciskPobierz.setFont(czcionkaEtykiety);
    panelPrzyciskow.add(przyciskPobierz);
    panelWejsciowy.add(panelPrzyciskow, BorderLayout.SOUTH);
    add(panelWejsciowy, BorderLayout.NORTH);
    JPanel panelWynikow = new JPanel();
    panelWynikow.setLayout(new BorderLayout());
    JLabel etykietaWynikow =
      new JLabel("Wyniki", JLabel.CENTER);
    etykietaWynikow.setFont(czcionkaNaglowka);
    panelWynikow.add(etykietaWynikow, BorderLayout.NORTH);
    poleWynikow = new JTextArea();
    poleWynikow.setFont(czcionkaTekstu);
    JScrollPane polePrzewijalneWynikow = 
      new JScrollPane(poleWynikow);    
    panelWynikow.add(polePrzewijalneWynikow, BorderLayout.CENTER);
    JPanel panelPrzerwij = new JPanel();
    przyciskPrzerwij = new JButton("Przerwij pobieranie");
    przyciskPrzerwij.addActionListener(this);
    przyciskPrzerwij.setFont(czcionkaEtykiety);
    panelPrzerwij.add(przyciskPrzerwij);
    panelWynikow.add(panelPrzerwij, BorderLayout.SOUTH);
    add(panelWynikow, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent zdarzenie) {
    if (zdarzenie.getSource() == przyciskPobierz) {
      Thread pobieracz = new Thread(this);
      pobieracz.start();
    } else if (zdarzenie.getSource() == przyciskPrzerwij) {
      wystapiloPrzerwanie = true;
    } 
  }

  public void run() {
    wystapiloPrzerwanie = false;
    if (argumentyPrawidlowe()) 
      new KlientHTTP(serwer, port, wierszZadania,
		     naglowkiZadania, poleWynikow, this);
  }
                         
  public boolean wystapiloPrzerwanie() {
    return(wystapiloPrzerwanie);
  }

  private boolean argumentyPrawidlowe() {
    serwer = poleSerwer.podajPoleTekstowe().getText();
    if (serwer.length() == 0) {
      powiadom("Brakuje nazwy serwer");
      return(false);
    }
    String portTekstowo =
      polePortu.podajPoleTekstowe().getText();
    if (portTekstowo.length() == 0) {
      powiadom("Brakuje numeru portu");
      return(false);
    }
    try {
      port = Integer.parseInt(portTekstowo);
    } catch(NumberFormatException nfe) {
      powiadom("Niepoprawny numer portu: " + portTekstowo);
      return(false);
    }
    wierszZadania =
      poleWierszaZadania.podajPoleTekstowe().getText();
    if (wierszZadania.length() == 0) {
      powiadom("Brakuje wiersza zadania");
      return(false);
    }
    podajNaglowkiZadania();
    return(true);
  }

  private void powiadom(String s) {
    poleWynikow.setText(s);
  }

  private void podajNaglowkiZadania() {
    for(int i=0; i<naglowkiZadania.length; i++) {
      naglowkiZadania[i] = null;
    }
    int liczbaNaglowkow = 0;
    String naglowek =
      poleNaglowkowZadania.getText();
    StringTokenizer analizator =
      new StringTokenizer(naglowek, "\r\n");
    while (analizator.hasMoreTokens()) {
      naglowkiZadania[liczbaNaglowkow++] = analizator.nextToken();
    }
  }
}