import java.net.*;
import java.io.*;
import javax.swing.*;

/** Klient sieciowy wykorzystywany przez program KlientWWW. 
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class KlientHTTP extends KlientSieciowy {
  private String wierszZadania;
  private String[] naglowkiZadania;
  private JTextArea poleWyjsciowe;
  private Przerywacz prog;
  
  public KlientHTTP(String serwer, int port,
                    String wierszZadania, String[] naglowkiZadania,
                    JTextArea poleWyjsciowe, Przerywacz prog) {
    super(serwer, port);
    this.wierszZadania = wierszZadania;
    this.naglowkiZadania = naglowkiZadania;
    this.poleWyjsciowe = poleWyjsciowe;
    this.prog = prog;
    if (sprawdzSerwer(serwer)) {
      polacz();
    }
  }

  protected void obsluzPolaczenie(Socket gniazdoUri)
      throws IOException {
    try {
	  PrintWriter wyjscie = NarzedziaSieciowe.podajPisarz(gniazdoUri);
      BufferedReader wejscie = NarzedziaSieciowe.podajCzytnik(gniazdoUri);
      poleWyjsciowe.setText("");
      wyjscie.println(wierszZadania);
      for(int i=0; i<naglowkiZadania.length; i++) {
        if (naglowkiZadania[i] == null) {
          break;
        } else {
          wyjscie.println(naglowkiZadania[i]);
        }
      }
      wyjscie.println();
      String wiersz;
      while ((wiersz = wejscie.readLine()) != null &&
             !prog.wystapiloPrzerwanie()) {
        poleWyjsciowe.append(wiersz + "\n");
      }
      if (prog.wystapiloPrzerwanie()) {
        poleWyjsciowe.append("---- Pobieranie przerwane ----");
      }
    } catch(Exception e) {
      poleWyjsciowe.setText("Bd: " + e);
    }
  }

  private boolean sprawdzSerwer(String serwer) {
    try {
      InetAddress.getByName(serwer);
      return(true);
    } catch(UnknownHostException uhe) {
      poleWyjsciowe.setText("Nieznany serwer: " + serwer);
      return(false);
    }
  }
}