import java.awt.*; // Dla klas FlowLayout, Font.
import javax.swing.*;

/** Pole tekstowe poczone z etykiet. 
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class EtykietowanePoleTekstowe extends JPanel {
  private JLabel etykieta;
  private JTextField poleTekstowe;
  
  public EtykietowanePoleTekstowe(String napisEtykiety,
                          Font czcionkaEtykiety,
                          int rozmiarPolaTekstowego,
                          Font czcionkaPolaTekstowego) {
    setLayout(new FlowLayout(FlowLayout.LEFT));
    etykieta = new JLabel(napisEtykiety, JLabel.RIGHT);
    if (czcionkaEtykiety != null) {
      etykieta.setFont(czcionkaEtykiety);
    }
    add(etykieta);
    poleTekstowe = new JTextField(rozmiarPolaTekstowego);
    if (czcionkaPolaTekstowego != null) {
      poleTekstowe.setFont(czcionkaPolaTekstowego);
    }
    add(poleTekstowe);
  }

  public EtykietowanePoleTekstowe(String napisEtykiety,
                          String napisPolaTekstowego) {
    this(napisEtykiety, null, napisPolaTekstowego,
         napisPolaTekstowego.length(), null);
  }

  public EtykietowanePoleTekstowe(String napisEtykiety,
                          int rozmiarPolaTekstowego) {
    this(napisEtykiety, null, rozmiarPolaTekstowego, null);
  }
  
  public EtykietowanePoleTekstowe(String napisEtykiety,
                          Font czcionkaEtykiety,
                          String napisPolaTekstowego,
                          int rozmiarPolaTekstowego,
                          Font czcionkaPolaTekstowego) {
    this(napisEtykiety, czcionkaEtykiety,
         rozmiarPolaTekstowego, czcionkaPolaTekstowego);
    poleTekstowe.setText(napisPolaTekstowego);
  }

  /** Etykieta umieszczona po lewej stronie kontrolki EtykietowanePoleTekstowe.
   *  Aby zmodyfikowa wartoci etykiety naley uy instrukcji:
   *  <PRE>
   *    EtykietowanePoleTekstowe ept = new EtykietowanePoleTekstowe(...);
   *    ept.podajEtykiete().dowolnaMetodaEtykiety(...);
   *  </PRE>
   */
  
  public JLabel podajEtykiete() {
    return(etykieta);
  }

  /** Pole tekstowe znajdujce si po prawej stronie kontrolki
   *  EtykietowanePoleTekstowe.
   */
  
  public JTextField podajPoleTekstowe() {
    return(poleTekstowe);
  }
}