/** Szablon demonstrujcy, w jaki sposb sterowa stanem wtku przez
 *  ustawianie wewntrznej flagi. 
 */

public class ZatrzymywalnyWatek extends Thread {

   public static final int ZATRZYMAJ = 0;
   public static final int WYKONUJ   = 1;
   public static final int CZEKAJ    = 2;
   private int stan = WYKONUJ;

  /** Metoda publiczna umoliwiajca ustawienie flagi powodujcej 
   *  zatrzymanie lub zawieszenie wtku. Monitorowaniem stanu
   *  zajmuje si specjalna metoda sprawdzStan().
   */

   public synchronized void ustawStan(int stan) {
      this.stan = stan;
      if (stan==WYKONUJ) {
         notify();
      }
   }

  /** Zwraca biecy stan wtku (WYKONUJ, ZATRZYMAJ, CZEKAJ).
   *  Normalnie, w przypadku otrzymania przerwania InterruptedException
   *  powinno si zmieni stan wtku lub wykona jak inn operacj. 
   */

   private synchronized int sprawdzStan() {
      while (stan==CZEKAJ) {
        try {
          wait();
        } catch (InterruptedException e) { }
      }
      return stan;
   }

  /** Przykad wtku, ktry bdzie kontynuowa przetwarzanie 
   *  do momentu, a obiekt sterujcy nie kae mu si zatrzyma.
   */

   public void run() {
      while (sprawdzStan()!=ZATRZYMAJ) {
         //...
      }
   }
}
