import java.io.*;

/** Przykad utworzenia procesu uruchamianego w tle wykonujcego
 *  metod, ktra oryginalnie nie bya wielowtkowa. Normalnie
 *  wykonywanie programu jest wstrzymywane dopki metoda obliczKlucz
 *  nie zostanie zakoczona.
 */
 
public class WielowatkowyKluczRSA extends KluczRSA implements Runnable {

  // Zapisz strLiczbaCyfr wewntrz wtku, aby uchroni si 
  // przed sytuacj wycigu.
  public void obliczKlucz(String strNumDigits) {
    WatekRSA t = new WatekRSA(this, strNumDigits);
    t.start();
  }

  // Pobierz zapisan warto strLiczbaCyfr i wywoaj oryginaln
  // metod. Dziki temu przetwarzanie odbywa si w tle.
  public void run() {
    WatekRSA t = (WatekRSA)Thread.currentThread();
    String strLiczbaCyfr = t.pobiezStrLiczbaCyfr();
    super.obliczKlucz(strLiczbaCyfr);
  }

  public static void main(String[] args){
    WielowatkowyKluczRSA key = new WielowatkowyKluczRSA();
    for (int i=0; i<args.length ; i++) {
        key.obliczKlucz(args[i]);
    }
  }
}

class WatekRSA extends Thread {
   protected String strLiczbaCyfr;
   
   public WatekRSA(Runnable obiektRsa, String strLiczbaCyfr) {
      super(obiektRsa);
      this.strLiczbaCyfr = strLiczbaCyfr;
   }

   public String pobiezStrLiczbaCyfr() {  
     return(strLiczbaCyfr); 
   }
}
